package regex;

import java.util.regex.*;

/**
 * Pokazuje sposób uwzględniania wielkość znaków wyrażeniach regularnych.
 * @author Ian F. Darwin, http://www.darwinsys.com/
 */
public class CaseMatch {
	public static void main(String[] argv) {
		String pattern = "^q[^u]\\d+\\.";
		String input = "Następny lot to QA777. Leci planowo.";

		Pattern reCaseInsens = Pattern.compile(pattern, Pattern.CASE_INSENSITIVE | Pattern.UNICODE_CASE);
		Pattern reCaseSens = Pattern.compile(pattern);

		boolean found;
		Matcher m;
		m = reCaseInsens.matcher(input);	// Dopasuje bez uwzględniania wielkość liter.
		found = m.lookingAt();				// Dopasuje bez uwzględniania wielkość liter.
		System.out.println("Dopasowanie z użyciem IGNORE_CASE " + found);

		m = reCaseSens.matcher(input);	// Pobranie obiektu matcher, w którym nie jest 
		                                // używana flaga ignorowania wielkości liter.
		found = m.lookingAt();		// Dopasuje z uwzględnianiem wielkość liter.
		System.out.println("Dopasowanie z użyciem MATCH_NORMAL " + found);

	}
}
