package otherlang;

import java.awt.Container;
import java.awt.FlowLayout;
import java.net.URL;
import java.util.Stack;
import java.util.logging.Logger;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

/**
 * Program ExecDemoNS pokazuje jak można wykonać program z poziomu Javy.
 */
// tag::main[]
public class ExecDemoNS extends JFrame {
    private static final String BROWSER = "firefox";
    
    Logger logger = Logger.getLogger(ExecDemoNS.class.getSimpleName());

    /** Nazwa pliku pomocy. */
    protected final static String HELPFILE = "./help/index.html";

    /** Stos obiektów procesów; każdy element tego stosu śledzi jeden
     *  wykonywany proces zewnętrzny. */
    Stack<Process> pStack = new Stack<>();

    /** Metoda main - inicjalizacja i uruchomienie. */
    public static void main(String av[]) throws Exception {
        String program = av.length == 0 ? BROWSER : av[0];
        new ExecDemoNS(program).setVisible(true);
    }

    /** Ścieżka do pliku wykonywalnego, który chcemy uruchomić. */
    protected static String program;

    /** Konstruktor - konfigurujemy wszystko... */
    public ExecDemoNS(String program) {
        super("ExecDemo: " + program);
        this.program = program;

        Container cp = getContentPane();
        cp.setLayout(new FlowLayout());
        JButton b;
        cp.add(b=new JButton("Uruchom"));
        b.addActionListener(e -> runProgram());
        cp.add(b=new JButton("Czekaj"));
        b.addActionListener(e -> doWait());
        cp.add(b=new JButton("Zakończ"));
        b.addActionListener(e -> System.exit(0));
        pack();
    }

    /** Uruchamiamy "system pomocy" we własnym wątku. */
    public void runProgram() {

        new Thread() {
            public void run() {

                try {
                    // Pobieramy URL do pliku pomocy.
                    URL helpURL = this.getClass().getClassLoader().
                        getResource(HELPFILE);

                    // Uruchamiamy zewnętrzną przeglądarkę z poziomu aplikacji
                    // napisanej w Javie.

                    String osname = System.getProperty("os.name");
                    String run;
                    if ("Mac OS X".equals(osname)) {
                        run = "open -a " + program;
                        // Użycie instrukcji warunkowej pozwala na zaimplementowanie
                        // specjalnej obsługi dla systemów operacyjnych, które tego
                        // wymagają.
                    } else {
                        run = program;
                    }

                    pStack.push(Runtime.getRuntime().exec(run + " " + helpURL));

                    logger.info("W metodzie main po wyokonaniu exec " + 
                            pStack.size());

                } catch (Exception ex) {
                    JOptionPane.showMessageDialog(ExecDemoNS.this,
                        "Błąd" + ex, "Błąd",
                        JOptionPane.ERROR_MESSAGE);
                }
            }
        }.start();

    }

    public void doWait() {
        if (pStack.size() == 0) {
            logger.info("Nie ma na co czekać...");
            return;
        }
        logger.info("Czekamy na proces " + pStack.size());
        try {
            Process p = pStack.pop();
            p.waitFor();
            // Czekamy na zakończenie procesu.
            // (W przypadku pewnych starych programów dla systemu Windows
            // rozwiązanie to może działać nieprawidłowo).
            logger.info("Proces " + p + " został zakończony.");
        } catch (Exception ex) {
            JOptionPane.showMessageDialog(this,
                "Błąd" + ex, "Błąd",
                JOptionPane.ERROR_MESSAGE);
        }
    }

}
// end::main[]
