package oo;

/** Przykład implementacji singletonu w Javie, z wykorzystaniem inicjalizatora 
 * statycznego.
 * Wzorzec Singleton został opisany w książce GoF, polega na tym
 * by zagwarantować, że w jednej aplikacji będzie istnieć tylko jedna
 * instancja danej klasy.
 * @author Ian F. Darwin, http://www.darwinsys.com/
 */
// tag::main[]
public class Singleton {

    /** Inicjalizator statyczny jest wykonywany zanim klasa będzie
     * dostępna dla kodu, co pozwala uniknąć antywzorca leniwej inicjalizacji
     * w metodzie instancyjnej. Jeśli operacja tworzenia instancji jest bardziej 
     * złożona, to można zastosować statyczny inicjalizator blokowy.
     */
    private static Singleton instance = new Singleton();

    /** Prywatny konstruktor uniemożliwia innym klasom tworzenie 
     * obiektów tej klasy. */
    private Singleton() {
        // Tym razem nie ma tu nic do zrobienia.
    }

    /** Statyczna metoda zwracająca obiekt. */
    public static Singleton getInstance() {
        return instance;
    }

    // Inne metody, do których dostęp jest chroniony przez singleton...  

    /** Prosta metoda demonstracyjna. */
    public String demoMethod() {
        return "demo";
    }
}
// end::main[]
