package numbers;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

/**
 * GetNumber - program służący do określania czy liczba jest zmiennoprzecinkowa czy całkowita.
 *
 * @author Ian Darwin, http://www.darwinsys.com/
 */
public class GetNumber extends Frame {

	private static final long serialVersionUID = 1L;
	/** Pole tekstowe do wprowadzania danych. */
	private TextField textField;
	/** Obszar na wyniki. */
	private TextField statusLabel;

	/** Konstruktor: przygotowanie graficznego interfejsu użytkownika. */
	public GetNumber() {
		Panel p = new Panel();
		p.add(new Label("Liczba:"));
		p.add(textField = new TextField(10));
		add(BorderLayout.NORTH, p);
		textField.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent ev) {
				String s = textField.getText();
				statusLabel.setText(process(s).toString());
			}
		});
		add(BorderLayout.SOUTH, statusLabel = new TextField(10));
		pack();
	}

	// tag::main[]
    /*
     * Przetwarza jeden łańcuch znaków, zwraca go w formie obiektu
     * klasy pochodnej Number. 
     */
    public static Number process(String s) {
        if (s.matches("[+-]*\\d*\\.\\d+[dDeEfF]*")) {
            try {
                double dValue = Double.parseDouble(s);
                System.out.println("Liczba zmiennoprzecinkowa: " + dValue);
                return Double.valueOf(dValue);
            } catch (NumberFormatException e) {
                System.out.println("Nieprawidłowa liczba zmiennoprzecinkowa: " + s);
                return Double.NaN;
            }
        } else // Nie zawiera znaków kropki, małych ani dużych liter d, e ani f; próbujemy zmienić na liczbę całkowitą.
            try {
                int iValue = Integer.parseInt(s);
                System.out.println("Liczba całkowita: " + iValue);
                return Integer.valueOf(iValue);
            } catch (NumberFormatException e2) {
                System.out.println("Dane wejściowe nie są liczbą: " + s);
                return Double.NaN;
            }
    }	// end::main[]

	public static void main(String[] ap) {
		new GetNumber().setVisible(true);
	}
}