package functional;

import java.util.List;

public class CameraSearchParallelStream {
	
	static List<Camera> privateListOfCameras = CameraUtils.getList();
	
	// tag::search[]
	public static void main(String[] args) {
		System.out.println("Poszykiwanie wyników przy użyciu pętli for.");
		for (Object camera : privateListOfCameras.parallelStream(). // <1>
				filter(c -> c.isIlc() && c.getPrice() < 500).       // <2>
				toArray()) {                                        // <3>
			System.out.println(camera);                             // <4>
		}

		System.out.println(
			"Poszukiwanie wyników przy użyciu prostszego, bardziej funkcyjnego rozwiązania.");
		privateListOfCameras.parallelStream().                      // <5>
                filter(c -> c.isIlc() && c.getPrice() < 500).
				forEach(System.out::println);
	}
	// end::search[]
}
