package datetime;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

/** Program przedstawia kilka przykładów tworzenia dat na podstawie
 * przekazanego łańcucha znaków. 
 */
// tag::part1[]
public class DateParse {
	public static void main(String[] args) {

		String armisticeDate = "1914-11-11";
		LocalDate aLD = LocalDate.parse(armisticeDate);
		System.out.println("Data: " + aLD);
		
		String armisticeDateTime = "1914-11-11T11:11";
		LocalDateTime aLDT = LocalDateTime.parse(armisticeDateTime);
		System.out.println("Data/godzina: " + aLDT);
		// end::part1[]
		
		// tag::part2[]
		DateTimeFormatter df = DateTimeFormatter.ofPattern("dd MMM uuuu");
		String anotherDate = "27 sty 2011";
		LocalDate random = LocalDate.parse(anotherDate, df);
        System.out.println("Łańcuch \"" + anotherDate + 
                "\" został przekształcony na datę " + random);
		// end::part2[]
		
		System.out.println(aLD + " po sformatowaniu ma postać " + df.format(aLD));
	}
}
