package structure;

// tag::main[]
/** Przykładowy stos dostosowany do użycia interfejsu SimpleStack. 
 */
public class ToyStack2 implements SimpleStack<Integer> {

	/** Maksymalna głębokość stosu. */
	protected int MAX_DEPTH = 10;
	/** Bieżąca głębokość stosu. */
	protected int depth = 0;
	/* Stos. */
	protected Integer[] stack = new Integer[MAX_DEPTH];

	@Override
	public boolean empty() {
		return depth == 0;
	}
	
	@Override
	public void push(Integer n) {
		stack[depth++] = n;
	}
	
	@Override
	public Integer pop() {
		return stack[--depth];
	}
	
	@Override
	public Integer peek() {
		return stack[depth-1];
	}
}
// end::main[]