package structure;

import java.util.LinkedList;
import java.util.ListIterator;

/**
 * Prezentacja użycia klasy java.util.LinkedList.
 * Używa tego samego przykładu co moja wcześniejsza klasa 
 * LinkList  (LinkListTest.java).
 * @author Ian Darwin, http://www.darwinsys.com/
 */
// tag::main[]
public class LinkedListDemo {
	public static void main(String[] argv) {
		System.out.println("Prezentacja klasy LinkedList.");
		LinkedList<String> l = new LinkedList<>();
		l.add(new Object().toString());
        l.add("Witam");
        l.add("Koniec listy");

		System.out.println("Oto lista wszystkich elementów");
		l.forEach(o -> 
			System.out.println("Kolejny element: " + o));

		if (l.indexOf("Witam") < 0)
            System.err.println("Nie udało się odnaleźć");
        else
            System.err.println("Odnaleziono");

        // A teraz, w ramach dodatkowej zabawy, pobierzemy wszystkie
        // elementy listy w odwrotnej kolejności.
		ListIterator<String> li = l.listIterator();
		while (li.hasPrevious()) {
			System.out.println("Poprzedni element: " + li.previous());
		}
	}
}
// end::main[]
