package structure;

import java.util.ArrayList;
import java.util.List;

import domain.Person;

/** Program pokazuje jak wstawiać elementy do dwóch list (list ArrayList 
 * oraz listy z biblioteki AWT) o określonej kolejności; do znajdowania 
 * obiektu przed którym należy wstawić nowy (lub końca listy) używane jest 
 * proste wyszukiwanie liniowe klasy ArrayList.
 */
// tag::main[]
public class CallTrack {

	/** Lista obiektów Person. */
	protected List<Person> usrList = new ArrayList<>();

	/** Lista z możliwością przewijania. */
	protected java.awt.List visList = new java.awt.List();

    /** Dodajemy do listy jeden (nowy) obiekt Person, przy czym 
     * cały czas jej zawartość jest posortowana. */
	protected void add(Person p) {
		String lastName = p.getLastName();
		int i;
        // Odnajdujemy i-tą pozycję na liście, gdzie należy wstawić
        // nową osobę.
		for (i=0; i<usrList.size(); i++)
			if (lastName.compareTo((usrList.get(i)).getLastName()) <= 0)
                break; // Bez tej instrukcji obiekt zostałby dodany
                       // na końcu listy.
		usrList.add(i, p);

        // Teraz do listy, którą można przewijać, dodajemy nową osobę,
        // umieszczając ją w tym samym miejscu listy.
		visList.add(p.getFullName(), i);
		visList.select(i);      // A teraz zaznaczamy nową osobę.
	}

}
// end::main[]
