package regex;

import java.util.regex.*;

/**
 * Parsuje plik dziennika serwera Apache przy użyciu wyrażeń regularnych.
 */
// tag::main[]
public class LogRegExp {

	final static String logEntryPattern = 
			"^([\\d.]+) (\\S+) (\\S+) \\[([\\w:/]+\\s[+-]\\d{4})\\] " +
			"\"(.+?)\" (\\d{3}) (\\d+) \"([^\"]+)\" \"([^\"]+)\"";

	public static void main(String argv[]) {

		System.out.println("Wyrażenie regularne:");
		System.out.println(logEntryPattern);

		System.out.println("Wiersz wejściowy:");
		String logEntryLine = LogParseInfo.LOG_ENTRY_LINE;
		System.out.println(logEntryLine);

		Pattern p = Pattern.compile(logEntryPattern);
		Matcher matcher = p.matcher(logEntryLine);
		if (!matcher.matches() || 
			LogParseInfo.MIN_FIELDS > matcher.groupCount()) {
            System.err.println("Nieprawidłowy wpis w dzienniku " 
                          + "(lub problem z wyrażeniem regularnym):");
			System.err.println(logEntryLine);
			return;
		}
		System.out.println("Adres IP: " + matcher.group(1));
		System.out.println("Użytkownik: " + matcher.group(3));
		System.out.println("Data/godzina: " + matcher.group(4));
		System.out.println("Żądanie: " + matcher.group(5));
		System.out.println("Odpowiedź: " + matcher.group(6));
		System.out.println("Liczba bajtów: " + matcher.group(7));
		if (!matcher.group(8).equals("-"))
			System.out.println("Adres strony: " + matcher.group(8));
		System.out.println("Przeglądarka: " + matcher.group(9));
	}
}
// end::main[]
