package network;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;

/**
 * A very very very simple Web server.
 *
 * There is only one response to all requests, and it's hard-coded.
 * This version is not threaded and doesn't do very much.
 * Really just a proof of concept.
 * However, it is still useful on notebooks in case somebody connects
 * to you on the Web port by accident (or otherwise).
 *
 * Can't claim to be fully standards-conforming, but has been
 * tested with various browsers.
 *
 * @author	Ian Darwin, http://www.darwinsys.com/
 */
// tag::main[]
public class WebServer0 {
    public static final int HTTP = 80;
    public static final String CRLF = "\r\n";
    ServerSocket s;
    /** Odnośnik do kodu źródłowego tego programu, 
     * używany w komunikatach o błędach. */
    static final String VIEW_SOURCE_URL =
    "https://github.com/IanDarwin/javasrc/tree/master/main/src/main/java/network";

    /**
     * Metoda main(), jej działanie ogranicza się do utworzenia 
     * serwera i wywołania jego metody runServer().
     */
    public static void main(String[] args) throws Exception {
        System.out.println("DarwinSys JavaWeb Server 0.0 startuję...");
        WebServer0 w = new WebServer0();
        int port = HTTP;
        if (args.length == 1) {
            port = Integer.parseInt(args[0]);
            }
        w.runServer(port);		// Działanie serwera nigdy się nie kończy!
    }

    /** Metoda zwraca faktyczny obiekt ServerSocket; przy czym jego 
     * pobranie jest odroczone w czasie i następuje dopiero po 
     * wykonaniu konstruktora, dzięki czemu klasy pochodne będą mogły
     * modyfikować działanie ServerSocketFactory (na przykład 
     * dodając możliwość korzystania z SSL).
     * @param port Numer portu, na którym serwer będzie nasłuchiwał.
     */
    protected ServerSocket getServerSocket(int port) throws Exception {
        return new ServerSocket(port);
    }

    /** Metoda runServer akceptuje połączenia i każde z nich osobno
     * przekazuje do obiektu obsługującego - Handler. */
    public void runServer(int port) throws Exception {
        s = getServerSocket(port);
        while (true) {
            try {
                Socket us = s.accept();
                Handler(us);
            } catch(IOException e) {
                System.err.println(e);
                return;
            }

        }
    }

    /** Metoda Handler() obsługuje jedno połączenie z klientem.
     * To jedyne miejsce programu, które musi "znać" protokół HTTP.
     */
    public void Handler(Socket s) {
        BufferedReader is;	// Strumień wejściowy od klienta.
        PrintWriter os;		// Strumień wyjściowy do klienta.
        String request;		// To, co klient nam przesłał.
        try {
            String from = s.getInetAddress().toString();
            System.out.println("Nawiązano połącznie z " + from);
            is = new BufferedReader(new InputStreamReader(s.getInputStream()));
            request = is.readLine();
            System.out.println("Żądanie: " + request);
            
            os = new PrintWriter(s.getOutputStream(), true);
            os.print("HTTP/1.0 200 To nadesłane dane" + CRLF);
            os.print("Content-type: text/html" + CRLF);
            os.print("Server-name: DarwinSys NULL Java WebServer 0" + CRLF);
            String reply1 = "<html><head>" +
                "<title>Żądanie dotarło do niewłaściwego serwera</title></head>\n" +
                "<h1>Witam, ";
            String reply2 = ", but...</h1>\n" +
                "<p>Żądanie dotarło na normalny komputer, na którym  " +
                "nie działa serwer WWW z prawdziwego zdarzenia.\n" +
                "<p>Proszę wybrać inny adres!</p>\n" +
                "<p>Albo zajrzyj na stronę <a href=\"" + 
                VIEW_SOURCE_URL + "\"> zawierającą kod źródłowy " +
                "serwera WebServer0, opublikowany na GitHubie</a>.</p>\n" +
                "<hr/><em>Serwer WebServer0 napisany w Javie</em><hr/>\n" +
                "</html>\n";
            os.print("Content-length: " + 
                (reply1.length() + from.length() + reply2.length()) + CRLF);
            os.print(CRLF);
            os.print(reply1 + from + reply2 + CRLF);
            os.flush();
            s.close();
        } catch (IOException e) {
            System.out.println("Błąd wejścia-wyjścia: " + e);
        }
        return;
    }
}
// end::main[]
