package netweb;

import java.io.*;
import java.net.URLEncoder;
import java.net.http.*;
import java.net.http.HttpClient.*;
import java.net.http.HttpResponse.*;
import java.net.*;

/**
 * Prosty przykład użycia API HttpClient Javy 11 (nie biblioteki Apache)
 */
public class HttpClientDemo {

	public static String urlString = 
		"https://suggestqueries.google.com/complete/search?client=firefox&q=";
	public static String keyword = "darwin";

	public static void main(String[] args)
		throws IOException, InterruptedException {

		// W prawdziwej aplikacji można by, w jakiś sposób, modyfikować
		// łańcuch urlString dodając do niego dodatkowe argumenty.

		// tag::setup[]
		// Ten obiekt może być przechowywany przez cały okres działania aplikacji.
		HttpClient client = HttpClient.newBuilder()
			.followRedirects(Redirect.NORMAL)
			.version(Version.HTTP_1_1)
			.build();

		// Tworzymy obiekt HttpRequst, by wykonać żądanie GET.
		HttpRequest req =
			HttpRequest.newBuilder(URI.create(urlString + 
				URLEncoder.encode(keyword)))
			.header("User-Agent", "Ministerstwo głupich kroków")
			.GET()
			.build();
		// end::setup[]

		// tag::sendSynch[]
		// Wysyłamy żądanie - w sposób synchroniczny.
		HttpResponse<String> resp = 
			client.send(req, BodyHandlers.ofString());

		// Pobranie wyników.
		if (resp.statusCode() == 200) {
			String response = resp.body();
			System.out.println(response);
		} else {
			System.out.printf("BŁĄD: Kod statusu %d odpowiedzi na żądanie %s\n",
				resp.statusCode(), urlString);
		}
		// end::sendSynch[]

		// tag::sendAsynch[]
		// Wysyłamy żądanie - w sposób asynchroniczny.
		client.sendAsync(req, BodyHandlers.ofString())
			.thenApply(HttpResponse::body)
			.thenAccept(System.out::println)
			.join();
		// end::sendAsynch[]

	}
}
