package logging;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

// tag::main[]
public class Log4JLambda {

    private static Logger myLogger = LogManager.getLogger();

    public static void main(String[] args) {

        Person customer = getPerson();
        myLogger.info( () -> String.format(
            "Wartość %d z obiektu Customer to: %s", customer.value, customer) );

    }
    // end::main[]

    // Minimalna implementacja. Usunięta z treści książki, bo nie ma znaczenia
    // dla samego przykładu

    static Person getPerson() {
        Person c = new Person();
        c.name = "Robert";
        c.value = 42;
        return c;
    }

    static class Person {
        int value = 42;
        String name;
        public String toString() {
            return "Customer[" + name + "]";
        }
    }
}
