package datetime;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;

/**
 * Przykład konwersji pomiędzy LocalData i starą klasą java.util.Date.
 */
// tag::main[]
public class LegacyDates {
	public static void main(String[] args) {

        // Konwersja w obu kierunkach przy użyciu obiektu Date.
		Date legacyDate = new Date();
		System.out.println(legacyDate);
		
		LocalDateTime newDate = 
			LocalDateTime.ofInstant(legacyDate.toInstant(), 
			ZoneId.systemDefault());
		System.out.println(newDate);
		
		Date backAgain =
			Date.from(newDate.atZone(ZoneId.systemDefault()).toInstant());
		System.out.println("Po skonwertowaniu z powrotem " + backAgain);

        // A teraz przy użyciu obiektu Calendar.
		Calendar c = Calendar.getInstance();
		System.out.println(c);
		LocalDateTime newCal = 
			LocalDateTime.ofInstant(c.toInstant(),
			ZoneId.systemDefault());
		System.out.println(newCal);
	}
}
// end::main[]
