package oo.interfaces;

import java.util.*;

/**
 * BuildingManagement - kontroluje energooszczędny budynek.
 * Klasa pokazuje w jaki sposób można by kontrolować obiekty w biurze
 * które bezpiecznie można wyłączyć na noc w celu oszczędzania energii
 * - i to dużych ilości energii, jeśli zostanie zastosowana w dużym biurze.
 */
// tag::main[]
public class BuildingManagement {

	List<Asset> things = new ArrayList<>();

    /** Scenariusz: metoda goodNight wywoływana przez wątek czasomierza o godzinie
     * 22:00 lub wówczas, gdy system otrzyma polecenie "shutdown" od 
     * strażnika.
     */
	public void goodNight() {
		things.forEach(obj -> {
			if (obj instanceof PowerSwitchable)
				((PowerSwitchable)obj).powerDown();
			});
	}

	// tag::functional[]
	public void goodNightFunctional() {
		things.stream().filter(obj -> obj instanceof PowerSwitchable)
			.forEach(obj -> ((PowerSwitchable)obj).powerDown());
	}
	// end::functional[]

    // Metoda goodMorning() działałaby bardzo podobnie, z tą 
    // różnicą, że wywoływałaby metodę powerUp().

    /** Metoda dodaje obiekt Asset do tego budynku. */
	public void add(Asset thing) {
		System.out.println("Dodajemy " + thing);
		things.add(thing);
	}

    /** Program główny. */
    public static void main(String[] av) {
        BuildingManagement b1 = new BuildingManagement();
        b1.add(new RoomLights(101));    // Oświetlenie w pokoju 101.
        b1.add(new EmergencyLight(101));    // Oświetlenie awaryjne.
        // Dodaj komputer na biurku nr 4 w pokoju 101.
        b1.add(new ComputerCPU(10104));
        // Dodaj monitor do tego komputera.
        b1.add(new ComputerMonitor(10104));

        // Czas mija... słońce zachodzi...
		b1.goodNight();
	}
}
// end::main[]
