package oo;

import java.time.LocalDate;
import java.util.List;
import java.util.Optional;

public class OptionalDemo {

    public static void main(String[] args) {
        // tag::items[]
        List.of(
            new Item("Element 1", LocalDate.now().plusDays(7)),
            new Item("Element 2")).
                forEach(System.out::println);
        // end::items[]

        Optional<String> opt = Optional.of("Co za dzień!");
        // opt = Optional.empty();
        if (opt.isPresent()) {
            System.out.println("Wartość wynosi: " + opt.get());
        } else {
            System.out.println("brak wartości.");
        }
        // Krótszy sposób:
        System.out.println("Wartość wynosi: " + opt.orElse("brak wartości"));
    }

    // tag::items[]
    static class Item {
        String name;
        Optional<LocalDate> dueDate;
        Item(String name) {
            this(name, null);
        }
        Item(String name, LocalDate dueDate) {
            this.name = name;
            this.dueDate = Optional.ofNullable(dueDate);
        }

        public String toString() {
            return String.format("%s %s", name,
                dueDate.isPresent() ?
                    "Data zakończenia obsługi " + dueDate.get() :
                    "Przykro mi, ale nie określono daty zakończenia.");
        }
    }
    // end::items[]
}
