//package numbers;

import java.util.BitSet;
import java.util.stream.IntStream;

/** Operacje na ciągach liczb całkowitych. */
public class NumSeries {
    public static void main(String[] args) {

        // W celu utworzenia ciągłego zbioru liczb całkowitych od n do m (włącznie) 
        // należy użyć metody rangeClosed(n, m).
        IntStream.rangeClosed(1, 12).forEach(
            i -> System.out.println("Miesiąc # " + i));
        
        // Można także użyć pętli for, zaczynając iteracje od wartości 1.
        for (int i = 1; i <= months.length; i++)
            System.out.println("Miesiąc # " + i);
        
        // Można również użyć pętli foreach.
        for (String month : months) {
            System.out.println(month);
        }
    
        // Aby określić wartości wartości elementów tablicy o indeksach z zadanego przedziału,
        // należy użyć metody range(początek, koniec), gdzie "koniec" nie zostanie uwzględniony.
        IntStream.range(0, months.length).forEach(
            i -> System.out.println("Miesiąc " + months[i]));
        
        // Można także użyć pętli for, zaczynając od 0.
        for (int i = 0; i < months.length; i++)
            System.out.println("Miesiąc " + months[i]);

        // Na przykład, aby policzyć od 11 do 27 co 3, należy użyć następującej pętli:
        for (int i = 11; i <= 27; i += 3) {
            System.out.println("i = " + i);
        }
        
        // Nieciągłe zbiory liczb tworzone przy użyciu klasy BitSet.

        // Tworzymy obiekt BitSet i ustawiamy kilka bitów.
        BitSet b = new BitSet();
        b.set(0);    // Styczeń.
        b.set(3);    // Kwiecień.
        b.set(8);    // Wrzesień.

        // Poniższa pętla zapewne znalazłaby się w jakiejś innej części kodu.
        for (int i = 0; i<months.length; i++) {
            if (b.get(i))
                System.out.println("Miesiąc " + months[i]);
        }

        // Nieco krótszy przykład:
        // nieciągły zbiór liczb utworzony z wykorzystaniem tablicy.
        int[] numbers = {0, 3, 8};

        // Pętla foreach, która pewnie powinna się znaleźć w innej części kodu.
        for (int n : numbers) {
            System.out.println("Miesiąc: " + months[n]);
        }
    }

    /** Nazwy miesięcy. Lepszy sposób ich określania można znaleźć w rozdziale
     *  poświęconym datom i godzinom. 
     */
    protected static String months[] = {
        "styczeń", "luty", "marzec", "kwiecień",
        "maj", "czerwiec", "lipiec", "sierpień",
        "wrzesień", "październik", "listopad", "grudzień"
    };
}
