package functional;

import java.util.Arrays;
import java.util.Comparator;

public class ReferencesDemo4 {

	static final List<String> unsortedNames = List.of(
		"Gosling", "de Raadt", "Amdahl", "Turing", "Ritchie", "Hopper"
	);
	
	public static void main(String[] args) {
		List<String> names;
		
        // Sortowanie z wykorzystaniem 
        // "metody instancyjnej dowolnego obiektu konkretnego typu".
		names = new ArrayList<>(unsortedNames);
		Collections.sort(names, String::compareToIgnoreCase);   // <1>
		dump(names);

        // Analogiczne sortowanie z użyciem wyrażenia lambda.
		names = new ArrayList<>(unsortedNames);
		Collections.sort(names, 
			(str1, str2) -> str1.compareToIgnoreCase(str2));    // <2>
		dump(names);
		
		// Analogiczne sortowanie wykonane w standardowy sposób.
		names = new ArrayList<>(unsortedNames);
		Collections.sort(names, new Comparator<String>() {      // <3>
			@Override
			public int compare(String str1, String str2) {
				return str1.compareToIgnoreCase(str2);
			}
		});
		dump(names);
		
		// Najprostszy sposób sortowania, z użyciem istniejącego komparatora.
		names = new ArrayList<>(unsortedNames);
		Collections.sort(names, String.CASE_INSENSITIVE_ORDER); // <4>
		dump(names);
	}
	// end::main[]

	/** Prosta metoda do wyświetlania kolejności nazwisk w tablicy */
	private static void dump(List<String> names) {
		System.out.print(String.join(", ", names));
		System.out.println();
	}

}
