package reflection;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.List;
import java.util.concurrent.Callable;

// tag::main[]
import javax.tools.JavaCompiler;
import javax.tools.SimpleJavaFileObject;
import javax.tools.ToolProvider;

/** Prezentacja API kompilatora Javy: tworzymy klasę, kompilujemy ją, wczytujemy
 * i uruchamiamy. 
 * Uwaga: ze względu na ustawienia ścieżki klasy ten przykład nie będzie działać 
 * w środowisku Eclipse; najlepiej będzie uruchamiać go z poziomu wiersza 
 * poleceń, używając polecenia: java JavaCompilerDemo.java.
 * @author Ian Darwin
 */
public class JavaCompilerDemo {
    private final static String PACKAGE = "reflection";
    private final static String CLASS = "AnotherDemo";
    private static boolean verbose;
    public static void main(String[] args) throws Exception {
        String source = "package " + PACKAGE + ";\n" +                  // <1>
            "public class " + CLASS + " {\n" +
            "\tpublic static void main(String[] args) {\n" +
            "\t\tString message = (args.length > 0 ? args[0] : \"Cześć\")" + ";\n" +
            "\t\tSystem.out.println(message + \" z klasy AnotherDemo\");\n" +
            "\t}\n}\n";
        if (verbose)
            System.out.print("Plik źródłowy do skompilowania:\n" + source);

        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();   // <2>
        if (compiler == null) {
            throw new IllegalStateException("Brak domyślnego kompilatora, " + 
                    "kończę działanie!");
        }
        Callable<Boolean> compilation = 
            compiler.getTask(null, null, null, List.of("-d","."), null, // <3>
            List.of(new MySource(CLASS, source)));
        boolean result = compilation.call();                            // <4>
        if (result) {
            System.out.println("Kompilacja zakończona pomyślnie");
            Class<?> c = Class.forName(PACKAGE + "." + CLASS);          // <5>
            System.out.println("Klasa = " + c);
            Method m = c.getMethod("main", args.getClass());            // <6>
            System.out.println("Deskryptor metody = " + m);
            Object[] passedArgs = { args };
            m.invoke(null, passedArgs);                                 // <7>
        } else {
            System.out.println("Kompilacja zakończona niepowodzeniem!");
        }
    }
}
// end::main[]
/** Klasa opakowująca używana do konwersji pliku na URL wymagany przez 
 * API kompilatora Javy. */
class MySource extends SimpleJavaFileObject {
    final String source;
    MySource(String fileName, String source) {
        super(URI.create("string:///" + fileName.replace('.', '/') + 
                Kind.SOURCE.extension), Kind.SOURCE);
        this.source = source;
    }
    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) {
        return source;	
    }
}

