package network;

import java.io.*;
import java.net.*;
import java.time.*;

/**
 * DaytimeObjectServer - server for the non-standard Time (LocalDateTime object) service.
 * @author Ian F. Darwin
 */
// tag::main[]
public class DaytimeObjectServer {
    /** Port TCP używany przez serwer. */
    public static final short TIME_PORT = 1951;

    public static void main(String[] argv) {
        ServerSocket sock;
        Socket clientSock;
        try {
            sock = new ServerSocket(TIME_PORT);
            while ((clientSock = sock.accept()) != null) {
                System.out.println("Odebrano połączenie z " +  
                    clientSock.getInetAddress());
                ObjectOutputStream os = new ObjectOutputStream(
                    clientSock.getOutputStream());

                // Tworzymy i zapisujemy obiekt.
                os.writeObject(new LocalDateTime.now());

                os.close();
            }

        } catch (IOException e) {
            System.err.println(e);
        }
    }
}
// end::main[]
