package logging;

import java.util.logging.Logger;

// tag::main[]
/** Program pokazuje w jaki sposób wyrażenia lambda w Java 8 pozwalają
 * uniknąć niepotrzebnego tworzenia obiektów.
 * @author Ian Darwin
 */
public class JulLambdaDemo {
    public static void main(String[] args) {

        Logger myLogger = Logger.getLogger("com.darwinsys.jullambda");

        Object o = new Helper();
        
        // Jeśli zmienimy wywołanie rejestrujące z "finest"
        // na "info", to zobaczymy zarówno informacje o wywołaniu
        // metody toString(), jak i informacje zapisane przez metodę
        // rejestrującą. W przypadku kodu w obecnej formie nic nie zobaczymy,
        // więc metoda toString() nie zostanie wywołana!
        myLogger.finest(() -> "Utworzyłem ten obiekt: " + o);
    }
    
    static class Helper {
        public String toString() {
            System.out.println("JulLambdaDemo.Helper.toString()");
            return "niepowodzenie!";
        }
    }
}
// end::main[]
