package io;

import java.io.*;

/**
 * Wczytuje dane z System.in i wyświetla w System.out używając klasy BufferedReader.
 */
// tag::main[]
public class CatStdin {

    public static void main(String[] av) {
        try (BufferedReader is =
            	new BufferedReader(new InputStreamReader(System.in))) {
            String inputLine;

            while ((inputLine = is.readLine()) != null) {
                System.out.println(inputLine);
            }
        } catch (IOException e) {
            System.out.println("Nieoczekiwany błąd wejścia-wyjścia: " + e);
        }
    }
}
// end::main[]
