package com.darwinsys.lang;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;

import com.darwinsys.io.FileIO;

// TODO: tłumaczenie nagłówka i komentarzy w kodzie

/**
 * ExecAndPrint wykonuje program używając metody Runtime.exec(),
 * wczytuje wyniki zwrócone przez program i zwraca jego kod wyjścia.
 */
public class ExecAndPrint {

	// tag::main[]
	/** Do wykonania każdej z tych metod potrzebny jest obiekt Runtime. */
	protected final static Runtime r = Runtime.getRuntime();

    /** Metoda wykonuje polecenie podane w formie łańcucha znaków (String)
     * i wyświetla jego wyniki w System.out (standardowym strumieniu wyjściowym).
     * @param cmd Polecenie.
     * @return Status zakończenia polecenia.
     * @throws IOException, jeśli polecenie nie zostało znalezione.
     */
	public static int run(String cmd) throws IOException { 
		return run(cmd, new OutputStreamWriter(System.out));
	}

    /** Metoda wykonuje polecenie podane w formie łańcucha znaków (String)
     * i wyświetla jego wyniki w strumieniu "out".
     * @param cmd Polecenie i lista argumentów.
     * @param out Plik wynikowy.
     * @return Status zakończenia polecenia.
     * @throws IOException, jeśli polecenie nie zostało znalezione.
     */
	public static int run(String cmd, Writer out) throws IOException {
		
		Process p = r.exec(cmd);

		FileIO.copyFile(new InputStreamReader(p.getInputStream()), out, true);
		try {
			p.waitFor();	// Czekamy na zakończenie procesu.
		} catch (InterruptedException e) {
			return -1;
		}
		return p.exitValue();
	}
	// end::main[]

	/** Run the command given as a String[], output to System.out
	 * @param cmd The command and list of arguments
	 * @return The command's exit status
	 * @throws IOException if the command isn't found
	 */
	public static int run(String[] cmd) throws IOException { 
		return run(cmd, new OutputStreamWriter(System.out));
	}

	/** Run the command given as a String[], print its output to "out"
	 * @param cmd The command and list of arguments
	 * @param out The output file
	 * @return The command's exit status
	 * @throws IOException if the command isn't found
	 */
	public static int run(String[] cmd, Writer out) throws IOException {
		
		Process p = r.exec(cmd);

		FileIO.copyFile(new InputStreamReader(p.getInputStream()), out, true);

		try {
			p.waitFor();	// wait for process to complete
		} catch (InterruptedException e) {
			return -1;
		}
		return p.exitValue();
	}
}