package strings;

import java.util.StringTokenizer;

/** Prezentacja wykorzystania klasy StringTokenizer wraz z mechanizmem 
 *  odrzucania separatorów.
 */
// tag::main[]
public class StrTokDemo4 {
    public final static int MAXFIELDS = 5;
    public final static String DELIM = "|";

    /** Przetwarza łańcuch znaków, zwracając go w formie tablicy łańcuchów */
    public static String[] process(String line) {
        String[] results = new String[MAXFIELDS];

        // Jeśli klasa StringTokenizer będzie pomijać wszelkie leksemy,
        // to powtarzające się puste leksemy będą ignorowane
        StringTokenizer st = new StringTokenizer(line, DELIM, true);

        int i = 0;
        // Wstawiamy każdy leksem do bieżącej komórki tablicy
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.equals(DELIM)) {
                if (i++>=MAXFIELDS)
                    // To nie jest najprostsze rozwiązanie - patrz przykład
                    // StrTokDemo4b wykorzystujący klasę List
                    throw new IllegalArgumentException("W wierszu wywołania " +
                        line + " podano zbyt wiele argumentów.");
                continue;
            }
            results[i] = s;
        }
        return results;
    }

    public static void printResults(String input, String[] outputs) {
        System.out.println("Dane wejściowe: " + input);
        for (String s : outputs)
            System.out.println("Wynik " + s + " to: " + s);
    }

    public static void main(String[] a) {
        printResults("A|B|C|D", process("A|B|C|D"));
        printResults("A||C|D", process("A||C|D"));
        printResults("A|||D|E", process("A|||D|E"));
    }
}
// end::main[]
