package network;

import java.io.*;
import java.net.*;

/**
 * EchoServer - tworzy gniazdo serwera i używa go do wykonywania operacji wejścia-wyjścia.
 *
 * @author Ian Darwin Copyright (c) 1995-2020 Ian F. Darwin
 */
// tag::main[]
public class EchoServer {
    /** Gniazdo używane przez serwer do komunikacji z klientem. */
    protected ServerSocket sock;
    /** Domyślny numer portu. */
    public final static int ECHOPORT = 7;
    /** Flaga kontrolująca testowanie. */
    protected boolean debug = true;

    /** Metoda main: tworzy obiekt serwera i uruchamia go. */
    public static void main(String[] args) {
        int p = ECHOPORT;
        if (args.length == 1) {
            try {
                p = Integer.parseInt(args[0]);
            } catch (NumberFormatException e) {
                System.err.println("Sposób użycia: EchoServer [port#]");
                System.exit(1);
            }
        }
        new EchoServer(p).handle();
    }

    /** Konstruktor, tworzy serwer EchoServer używający podanego portu. */
    public EchoServer(int port) {
        try {
            sock = new ServerSocket(port);
        } catch (IOException e) {
            System.err.println("Błąd wejścia-wyjścia podczas konfiguracji.");
            System.err.println(e);
            System.exit(1);
        }
    }

    /** Metoda obsługująca połączenia. */
    protected void handle() {
        Socket ios = null;
        while (true) {
            try {
                System.out.println("Czekamy na klienta...");
                ios = sock.accept();
                System.err.println("Odebrano połączenie od " +
                    ios.getInetAddress().getHostName());
                try (BufferedReader is = new BufferedReader(
                            new InputStreamReader(ios.getInputStream(), "8859_1"));
                        PrintWriter os = new PrintWriter(
                            new OutputStreamWriter(ios.getOutputStream(), "8859_1"),
                            true);) {
                    String echoLine;
                    while ((echoLine = is.readLine()) != null) {
                        System.err.println("Odczytano " + echoLine);
                        os.print(echoLine + "\r\n");
                        os.flush();
                        System.err.println("Zapisano " + echoLine);
                    }
                    System.err.println("Gotowe!");
                }
            } catch (IOException e) {
                System.err.println(e);
            }
        }
        /*NIEOSIĄGANE*/
    }
}
// end::main[]
