package datetime;

import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;

/**
 * "Twoje dzieci podróżują same samolotem z Ameryki do Europy. Lot z YYZ
 * trwa 5 godzin i 10 minut licząc od momentu wylotu. Teściowie potrzebują 
 * godziny na dotarcie do lotniska LHR i znalezienie miejsca parkingowego.
 * O której należy do nich zadzwonić, żeby wyjechali na lotnisko?"
 * @author Ian Darwin, w oparciu o podobne obliczenia opracowane przez Chrisa Mawatę.
 */
// tag::main[]
public class FlightArrivalTimeCalc {

    static Duration driveTime = Duration.ofHours(1);

    public static void main(String[] args) {
        LocalDateTime when = null;
        if (args.length == 0) {
            when = LocalDateTime.now();                                        // <1>
        } else {
            String time = args[0];
            LocalTime localTime = LocalTime.parse(time);
            when = LocalDateTime.of(LocalDate.now(), localTime);               // <1>
        }
        calulateArrivalTime(when);
    }

    public static ZonedDateTime calulateArrivalTime(LocalDateTime takeOffTime) {
        ZoneId torontoZone = ZoneId.of("America/Toronto"),
                londonZone = ZoneId.of("Europe/London");
        ZonedDateTime takeOffTimeZoned =
            ZonedDateTime.of(takeOffTime, torontoZone);                        // <2>
        Duration flightTime =
            Duration.ofHours(5).plus(10, ChronoUnit.MINUTES);                  // <3>
        ZonedDateTime arrivalTimeUnZoned = takeOffTimeZoned.plus(flightTime);  // <4>
        ZonedDateTime arrivalTimeZoned =
            arrivalTimeUnZoned.toInstant().atZone(londonZone);                 // <5>
        ZonedDateTime phoneTimeHere = arrivalTimeUnZoned.minus(driveTime);     // <6>

        System.out.println("Godzina wylotu " + takeOffTimeZoned);
        System.out.println("Oczekiwana długość lotu: " + flightTime);
        System.out.println(
            "Samolot przylatuje o godzinie " + arrivalTimeZoned + " czasu w Londynie.");
        System.out.println("Należy zadzwonić o godzinie " + phoneTimeHere + " czasu w Toronto.");
        return arrivalTimeZoned;
    }
}
// end::main[]
