package threads;

import java.awt.BorderLayout;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.net.URL;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

/** Kod klasy Bounce; tworzy i uruchamia obiekty Sprite, używając do tego celu 
 * wątków Threads 
 */
// tag::main[]
public class Bounce extends JPanel {

    private static final long serialVersionUID = -5359162621719520213L;
    /** Panel główny. */
    protected JPanel p;
    /** Obrazek wykorzystywany wspólnie przez wszystkie obiekty Sprite. */
    protected Image img;
    /** Pula wątków. */
    protected ExecutorService tp = Executors.newCachedThreadPool();
    /** Obiekt Vector zawierający obiekty Sprite. */
    protected List<Sprite> v = new Vector<Sprite>(); // Program wielowątkowowy, 
                                                     // trzeba użyć obiektu Vector.

    public static void main(String[] args) {
        JFrame jf = new JFrame("Program demonstracyjny Bounce");
        jf.add(new Bounce(args.length > 0 ? args[0] : null));
        jf.setSize(300, 300);
        jf.setVisible(true);
        jf.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    }

    public Bounce(String imgName) {
        setLayout(new BorderLayout());
        JButton b = new JButton("Dodaj duszka");
        b.addActionListener(e -> {
            System.out.println("Tworzenie kolejengo duszka!");
            Sprite s = new Sprite(this, img);
            tp.execute(s);
            p.add(s);
            v.add(s);
        });
        add(b, BorderLayout.NORTH);
        add(p = new JPanel(), BorderLayout.CENTER);
        p.setLayout(null);
        if (imgName == null) imgName = "duke.gif";
        final URL resource = getClass().getResource("/" + imgName);
        if (resource == null) {
            throw new IllegalStateException("Nie można pobrać obrazu " + imgName);
        }
        img = Toolkit.getDefaultToolkit().getImage(resource);
        MediaTracker mt = new MediaTracker(this);
        mt.addImage(img, 0);
        try {
            mt.waitForID(0);
        } catch(InterruptedException e) {
            throw new IllegalArgumentException(
                "InterruptedException podczas pobierania obrazu " + imgName);
        }
        if (mt.isErrorID(0)) {
            throw new IllegalArgumentException(
                "Nie można wczytać obrazu " + imgName);
        }
        JButton stopper = new JButton("Zamknij");
        stopper.addActionListener(e -> {
            stop();
            tp.shutdown();
        });
        add(stopper, BorderLayout.SOUTH);
    }

    public void stop() {
        for (Sprite s : v) {
            s.stop();
        }
        v.clear();
        try {
            tp.awaitTermination(5, TimeUnit.SECONDS);
            System.out.println("Zamknięto pulę wątków (ThreadPool), " + 
                               " kończenie działania programu.");
            System.exit(0);
        } catch (InterruptedException e) {
            // Pusty.
        }
    }
}
// end::main[]
