package threads;

/*
 * Copyright (c) Ian F. Darwin, http://www.darwinsys.com/, 1996-2002.
 * All rights reserved. Software written by Ian F. Darwin and others.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *        This product includes software developed by Ian F. Darwin.
 * 4. Neither the name of the author nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Java, the Duke mascot, and all variants of Sun's Java "steaming coffee
 * cup" logo are trademarks of Sun Microsystems. Sun's, and James Gosling's,
 * pioneering role in inventing and promulgating (and standardizing) the Java 
 * language and environment is gratefully acknowledged.
 * 
 * The pioneering role of Dennis Ritchie and Bjarne Stroustrup, of AT&T, for
 * inventing predecessor languages C and C++ is also gratefully acknowledged.
 */

// import - Brak.

/** Demonstration of using a Thread to automatically save
 * the user's work periodically.
 */
// tag::main[]
public class AutoSave extends Thread {
    /** Interfejs FileSave jest implementowany przez klasę główną. */
    protected FileSaver model;
    /** Odstęp pomiędzy kolejnymi próbami zapisu. */
    public static final int MINUTES = 5;
    private static final int SECONDS = MINUTES * 60;

    public AutoSave(FileSaver m) {
        super("Wątek AutoSave");
        setDaemon(true);		// Aby aplikacja główna nie musiała działać.
        model = m;
    }

    public void run() {
        while (true) {		// Metoda run działa w nieskończonej pętli.
            try {
                sleep(SECONDS*1000);
            } catch (InterruptedException e) {
                // Nic z tym nie robimy.
            }
            if (model.wantAutoSave() && model.hasUnsavedChanges())
                model.saveFile(null);
        }
    }

    // Czego tutaj nie pokazano:
    // 1) Metoda saveFile() musi być synchronizowana.
    // 2) Metoda, która zamyka program główny, musi być synchronizowana 
    //    przy użyciu *tego samego* obiektu.
}

/** Lokalna kopia interfejsu FileSaver, potrzebna do skompilowania 
 *  programu AutoSave. 
interface FileSaver {
    /** Metoda wczytuje nowy model z fn; jeśli przekazano null, należy poprosić
     *  o nową nazwę pliku. 
     */
    public void loadFile(String fn);

    /** Metoda pyta model, czy należy wykonać automatyczny zapis. */
    public boolean wantAutoSave();

    /** Metoda pyta model, czy istnieją jakieś niezapisane zmiany, jeśli żadnych
     * zmian nie ma, operacja zapisu nie zostanie wykonana. 
     */
    public boolean hasUnsavedChanges();

    /** Metoda zapisuje bieżące dane modelu w pliku o podanej nazwie.
     * Jeśli przekazano null, należy użyć bieżącego pliku, a jeśli takiego nie ma,
     * to trzeba poprosić o podanie nazwy.
     */
    public void saveFile(String fn);
}
// end::main[]
