package strings;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;

/**
 * CheckSum - program oblicza i wyświetla sumę kontrolną pliku.
 * @author Ian F. Darwin, http://www.darwinsys.com/
 */
public class CheckSum {
    public static void main(String[] args) {
        int sum = 0;
        if (args.length == 0) {
            sum = CheckSum.process(new BufferedReader(
            new InputStreamReader(System.in)));
        } else for (String arg : args) {
            try {
                sum += CheckSum.process(
					new BufferedReader(new FileReader(arg)));
            } catch (FileNotFoundException e) {
                throw new RuntimeException("File not found: " + arg, e);
            }
		}
        System.out.println(sum);
    }

    // tag::main[]
    /** Suma kontrolna zawartości otwartego strumienia BufferedReader.
     *  Ta wersja metody nie uwzględnia znaków końca
     *  wiersza, zatem zwróci identyczne wyniki dla tego samego tekstu
     *  niezależnie od platformy, w której plik został zapisany.
     *  Metody nie należy używać do przetwarzania plików binarnych!
     */
    public static int process(BufferedReader is) {
        int sum = 0;
        try {
            String inputLine;

            while ((inputLine = is.readLine()) != null) {
                for (char c : inputLine.toCharArray()) {
                    sum += c;
                }
            }
        } catch (IOException e) {
            throw new RuntimeException("IOException: " + e);
        }
        return sum;
    }
    // end::main[]
}
