package network;

import java.io.*;
import java.net.*;

/**
 * Listen -- program tworzy instancję ServerSocket i oczekuje na połączenia.
 * @author Ian F. Darwin
 */
// tag::main[]
public class Listen {
	/** Port TCP używany przez usługę. */
	public static final short PORT = 9999;

	public static void main(String[] argv) throws IOException {
		ServerSocket sock;
		Socket clientSock;
		try {
			sock = new ServerSocket(PORT);
			while ((clientSock = sock.accept()) != null) {

                // Przetwarzamy żądanie... zazwyczaj w osobnym wątku,
                // by uniknąć zablokowania wywołania accept().
				process(clientSock);
			}

		} catch (IOException e) {
			System.err.println(e);
		}
	}

	/** Ta metoda w jakiś sposób obsłużyłaby połączenie z klientem. */
	static void process(Socket s) throws IOException {
		System.out.println("Zaakceptowano połączenie z klientem " + s.getInetAddress());
		// Wymiana danych między serwerem i klientem.
		s.close();
	}
}
// end::main[]
