/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.filter.swing;

import java.util.Arrays;
import javax.swing.filechooser.FileNameExtensionFilter;
import uk.co.caprica.vlcj.filter.AudioFileFilter;
import uk.co.caprica.vlcj.filter.PlayListFileFilter;
import uk.co.caprica.vlcj.filter.SubTitleFileFilter;
import uk.co.caprica.vlcj.filter.VideoFileFilter;

public class FileNameExtensionFilterFactory {
    private static final String VIDEO_FILTER_DESCRIPTION = "Video Files";
    private static final String AUDIO_FILTER_DESCRIPTION = "Audio Files";
    private static final String PLAYLIST_FILTER_DESCRIPTION = "Playlist Files";
    private static final String MEDIA_FILTER_DESCRIPTION = "Media Files";
    private static final String SUBTITLE_FILTER_DESCRIPTION = "Subtitle Files";

    public static FileNameExtensionFilter newVideoFileNameExtensionFilter() {
        return new FileNameExtensionFilter(VIDEO_FILTER_DESCRIPTION, VideoFileFilter.INSTANCE.getExtensions());
    }

    public static FileNameExtensionFilter newAudioFileNameExtensionFilter() {
        return new FileNameExtensionFilter(AUDIO_FILTER_DESCRIPTION, AudioFileFilter.INSTANCE.getExtensions());
    }

    public static FileNameExtensionFilter newPlayListFileFilter() {
        return new FileNameExtensionFilter(PLAYLIST_FILTER_DESCRIPTION, PlayListFileFilter.INSTANCE.getExtensions());
    }

    public static FileNameExtensionFilter newMediaFileNameExtensionFilter() {
        return new FileNameExtensionFilter(MEDIA_FILTER_DESCRIPTION, FileNameExtensionFilterFactory.add(FileNameExtensionFilterFactory.add(VideoFileFilter.INSTANCE.getExtensions(), AudioFileFilter.INSTANCE.getExtensions()), PlayListFileFilter.INSTANCE.getExtensions()));
    }

    public static FileNameExtensionFilter newSubtitleFileFilter() {
        return new FileNameExtensionFilter(SUBTITLE_FILTER_DESCRIPTION, SubTitleFileFilter.INSTANCE.getExtensions());
    }

    private static String[] add(String[] first, String[] second) {
        String[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }
}

