/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import org.springframework.asm.Label;
import org.springframework.asm.MethodVisitor;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.spel.CodeFlow;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.ast.Operator;
import org.springframework.expression.spel.ast.SpelNodeImpl;
import org.springframework.expression.spel.support.BooleanTypedValue;

public class OpNE
extends Operator {
    public OpNE(int pos, SpelNodeImpl ... operands) {
        super("!=", pos, operands);
        this.exitTypeDescriptor = "Z";
    }

    @Override
    public BooleanTypedValue getValueInternal(ExpressionState state) throws EvaluationException {
        Object left = this.getLeftOperand().getValueInternal(state).getValue();
        Object right = this.getRightOperand().getValueInternal(state).getValue();
        this.leftActualDescriptor = CodeFlow.toDescriptorFromObject(left);
        this.rightActualDescriptor = CodeFlow.toDescriptorFromObject(right);
        return BooleanTypedValue.forValue(!this.equalityCheck(state, left, right));
    }

    @Override
    public boolean isCompilable() {
        SpelNodeImpl left = this.getLeftOperand();
        SpelNodeImpl right = this.getRightOperand();
        if (!left.isCompilable() || !right.isCompilable()) {
            return false;
        }
        String leftdesc = left.getExitDescriptor();
        String rightdesc = right.getExitDescriptor();
        Operator.DescriptorComparison dc = Operator.DescriptorComparison.checkNumericCompatibility(leftdesc, rightdesc, this.leftActualDescriptor, this.rightActualDescriptor);
        if (dc.areNumbers) {
            return dc.areCompatible;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void generateCode(MethodVisitor mv, CodeFlow codeflow) {
        String leftDesc = this.getLeftOperand().getExitDescriptor();
        String rightDesc = this.getRightOperand().getExitDescriptor();
        Label elseTarget = new Label();
        Label endOfIf = new Label();
        boolean leftPrim = CodeFlow.isPrimitive(leftDesc);
        boolean rightPrim = CodeFlow.isPrimitive(rightDesc);
        Operator.DescriptorComparison dc = Operator.DescriptorComparison.checkNumericCompatibility(leftDesc, rightDesc, this.leftActualDescriptor, this.rightActualDescriptor);
        if (dc.areNumbers && dc.areCompatible) {
            char targetType = dc.compatibleType;
            this.getLeftOperand().generateCode(mv, codeflow);
            if (!leftPrim) {
                CodeFlow.insertUnboxInsns(mv, targetType, leftDesc);
            }
            codeflow.enterCompilationScope();
            this.getRightOperand().generateCode(mv, codeflow);
            codeflow.exitCompilationScope();
            if (!rightPrim) {
                CodeFlow.insertUnboxInsns(mv, targetType, rightDesc);
            }
            if (targetType == 'D') {
                mv.visitInsn(151);
                mv.visitJumpInsn(153, elseTarget);
            } else if (targetType == 'F') {
                mv.visitInsn(149);
                mv.visitJumpInsn(153, elseTarget);
            } else if (targetType == 'J') {
                mv.visitInsn(148);
                mv.visitJumpInsn(153, elseTarget);
            } else {
                if (targetType != 'I' && targetType != 'Z') throw new IllegalStateException("Unexpected descriptor " + leftDesc);
                mv.visitJumpInsn(159, elseTarget);
            }
        } else {
            this.getLeftOperand().generateCode(mv, codeflow);
            this.getRightOperand().generateCode(mv, codeflow);
            mv.visitJumpInsn(165, elseTarget);
        }
        mv.visitInsn(4);
        mv.visitJumpInsn(167, endOfIf);
        mv.visitLabel(elseTarget);
        mv.visitInsn(3);
        mv.visitLabel(endOfIf);
        codeflow.pushDescriptor("Z");
    }
}

