/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.tools;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XrefCheck {
    private static final boolean VERBOSE_SELFTEST = false;
    static final Set<String> decls = new HashSet<String>();
    static final Map<String, String> refs = new HashMap<String, String>();
    static final Pattern decl = Pattern.compile("^\\[\\[([^,]+?)\\]\\]$");
    static final Pattern ref = Pattern.compile("<<([^,]+?)>>");
    private static final boolean VERBOSE_RUN = false;

    public static void main(String[] args) throws Exception {
        XrefCheck.selfTest(false);
        for (String file : args) {
            try {
                XrefCheck.accumulateXrefs(file, false);
            }
            catch (Exception e) {
                System.out.println(e + " in file " + file);
            }
        }
        for (String s : refs.keySet()) {
            if (decls.contains(s)) continue;
            System.out.println(refs.get(s) + " use of undeclared ref " + s);
        }
    }

    public static void selfTest(boolean verbose) {
        Matcher md = decl.matcher("[[dog-chapter]]");
        md.find();
        if (verbose) {
            System.out.println("DECL: " + md.group(1));
        }
        if (!"dog-chapter".equals(md.group(1))) {
            throw new IllegalStateException("Failed to match decl");
        }
        Matcher mr = ref.matcher("see woof <<dog-chapter>> or meow <<cat_chapter>>.");
        int i = 0;
        while (mr.find()) {
            ++i;
            if (!verbose) continue;
            System.out.println("REF: " + mr.group(1));
        }
        if (i != 2) {
            throw new IllegalStateException("Failed to match 2 xrefs");
        }
    }

    public static void accumulateXrefs(String fileName, boolean verbose) throws Exception {
        try (BufferedReader is = new BufferedReader(new FileReader(fileName));){
            String line = null;
            int lineNumber = 0;
            while ((line = is.readLine()) != null) {
                ++lineNumber;
                if (line.length() == 0) continue;
                if (line.startsWith("[[")) {
                    Matcher md = decl.matcher(line);
                    if (!md.find()) {
                        System.out.println("Misformed label: " + line);
                        continue;
                    }
                    decls.add(md.group(1));
                    if (!verbose) continue;
                    System.out.println("decl:" + md.group(1));
                    continue;
                }
                Matcher mr = ref.matcher(line);
                while (mr.find()) {
                    String ref = mr.group(1);
                    refs.put(ref, fileName + ":" + lineNumber);
                    if (!verbose) continue;
                    System.out.println("ref: " + mr.group(1));
                }
            }
        }
    }
}

