/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.swingui;

import java.awt.Container;
import java.awt.Cursor;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;

public class SimpleHelp
extends JFrame
implements HyperlinkListener {
    private static final long serialVersionUID = 5198536352002184299L;
    JEditorPane help;

    public SimpleHelp(String windowName, String helpIndexFileName) {
        super(windowName + " Help Window");
        Container cp = this.getContentPane();
        this.getAccessibleContext().setAccessibleName(windowName + " Help Window");
        this.getAccessibleContext().setAccessibleDescription("A window for viewing the help for " + windowName + ", which is somewhat hyperlinked.");
        try {
            URL url = new URL(new File(helpIndexFileName).getAbsolutePath());
            this.help = new JEditorPane(url);
            this.help.setEditable(false);
            this.help.addHyperlinkListener(this);
            JScrollPane scroller = new JScrollPane();
            scroller.setBorder(BorderFactory.createTitledBorder(windowName + " Help"));
            scroller.getViewport().add(this.help);
            cp.add("Center", scroller);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    SimpleHelp.this.setVisible(false);
                    SimpleHelp.this.dispose();
                }
            });
            this.setSize(500, 400);
        }
        catch (MalformedURLException e) {
            System.out.println("Malformed URL: " + e);
        }
        catch (IOException e) {
            System.out.println("IOException: " + e);
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            URL target = e.getURL();
            Cursor oldCursor = this.help.getCursor();
            Cursor waitCursor = Cursor.getPredefinedCursor(3);
            this.help.setCursor(waitCursor);
            SwingUtilities.invokeLater(new PageLoader(target, oldCursor));
        }
    }

    class PageLoader
    implements Runnable {
        URL url;
        Cursor cursor;

        PageLoader(URL u, Cursor c) {
            this.url = u;
            this.cursor = c;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.url == null) {
                SimpleHelp.this.help.setCursor(this.cursor);
                Container parent = SimpleHelp.this.help.getParent();
                parent.repaint();
            } else {
                Document doc = SimpleHelp.this.help.getDocument();
                try {
                    SimpleHelp.this.help.setPage(this.url);
                }
                catch (Exception ioe) {
                    SimpleHelp.this.help.setDocument(doc);
                    SimpleHelp.this.getToolkit().beep();
                }
                finally {
                    this.url = null;
                    SwingUtilities.invokeLater(this);
                }
            }
        }
    }
}

