/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.inputHtml;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import org.apache.myfaces.component.UserRoleUtils;
import org.apache.myfaces.component.html.util.AddResource;
import org.apache.myfaces.custom.inputHtml.InputHtml;
import org.apache.myfaces.renderkit.RendererUtils;
import org.apache.myfaces.renderkit.html.HtmlRenderer;
import org.apache.myfaces.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.renderkit.html.util.HTMLEncoder;
import org.apache.myfaces.renderkit.html.util.JavascriptUtils;

public class InputHtmlRenderer
extends HtmlRenderer {
    static /* synthetic */ Class class$org$apache$myfaces$custom$inputHtml$InputHtml;
    static /* synthetic */ Class class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer;

    protected boolean isDisabled(FacesContext facesContext, UIComponent uiComponent) {
        if (!UserRoleUtils.isEnabledOnUserRole(uiComponent)) {
            return false;
        }
        return ((InputHtml)uiComponent).isDisabled();
    }

    private static boolean useFallback(InputHtml editor) {
        return editor.getFallback().equals("true");
    }

    public void encodeEnd(FacesContext context, UIComponent uiComponent) throws IOException {
        RendererUtils.checkParamValidity(context, uiComponent, class$org$apache$myfaces$custom$inputHtml$InputHtml == null ? (class$org$apache$myfaces$custom$inputHtml$InputHtml = InputHtmlRenderer.class$("org.apache.myfaces.custom.inputHtml.InputHtml")) : class$org$apache$myfaces$custom$inputHtml$InputHtml);
        InputHtml editor = (InputHtml)uiComponent;
        if (HtmlRendererUtils.isDisplayValueOnly(editor)) {
            this.encodeDisplayValueOnly(context, editor);
        } else if (InputHtmlRenderer.useFallback(editor)) {
            this.encodeEndFallBackMode(context, editor);
        } else {
            this.encodeEndNormalMode(context, editor);
        }
    }

    private void encodeDisplayValueOnly(FacesContext context, InputHtml editor) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("span", editor);
        HtmlRendererUtils.writeIdIfNecessary(writer, editor, context);
        HtmlRendererUtils.renderDisplayValueOnlyAttributes(editor, writer);
        String text = RendererUtils.getStringValue(context, editor);
        writer.write(editor.getHtmlBody(text));
        writer.endElement("span");
    }

    private void encodeEndFallBackMode(FacesContext context, InputHtml editor) throws IOException {
        String clientId = editor.getClientId(context);
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("textarea", editor);
        writer.writeAttribute("name", clientId, null);
        HtmlRendererUtils.writeIdIfNecessary(writer, editor, context);
        if (editor.getStyle() != null) {
            writer.writeAttribute("style", editor.getStyle(), null);
        }
        if (editor.getStyleClass() != null) {
            writer.writeAttribute("class", editor.getStyleClass(), null);
        }
        if (this.isDisabled(context, editor)) {
            writer.writeAttribute("disabled", Boolean.TRUE, null);
        }
        String text = RendererUtils.getStringValue(context, editor);
        writer.write(InputHtmlRenderer.htmlToPlainText(text, editor));
        writer.endElement("textarea");
    }

    private static String htmlToPlainText(String html, InputHtml editor) {
        return editor.getHtmlBody(html).replaceAll("<br.*>", "\n").replaceAll("<.+?>", "");
    }

    private void encodeEndNormalMode(FacesContext context, InputHtml editor) throws IOException {
        String clientId = editor.getClientId(context);
        UIComponent tmpComponent = editor.getParent();
        while (!(tmpComponent instanceof UIForm)) {
            tmpComponent = tmpComponent.getParent();
        }
        String formId = tmpComponent.getClientId(context);
        AddResource.addStyleSheet(class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer == null ? (class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer = InputHtmlRenderer.class$("org.apache.myfaces.custom.inputHtml.InputHtmlRenderer")) : class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer, "kupustyles.css", context);
        AddResource.addStyleSheet(class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer == null ? (class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer = InputHtmlRenderer.class$("org.apache.myfaces.custom.inputHtml.InputHtmlRenderer")) : class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer, "kupudrawerstyles.css", context);
        AddResource.addStyleSheet(class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer == null ? (class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer = InputHtmlRenderer.class$("org.apache.myfaces.custom.inputHtml.InputHtmlRenderer")) : class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer, "myFaces.css", context);
        AddResource.addJavaScriptToHeader(class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer == null ? (class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer = InputHtmlRenderer.class$("org.apache.myfaces.custom.inputHtml.InputHtmlRenderer")) : class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer, "sarissa.js", context);
        AddResource.addJavaScriptToHeader(class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer == null ? (class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer = InputHtmlRenderer.class$("org.apache.myfaces.custom.inputHtml.InputHtmlRenderer")) : class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer, "sarissa_ieemu_xpath.js", context);
        AddResource.addJavaScriptToHeader(class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer == null ? (class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer = InputHtmlRenderer.class$("org.apache.myfaces.custom.inputHtml.InputHtmlRenderer")) : class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer, "kupuhelpers.js", context);
        AddResource.addJavaScriptToHeader(class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer == null ? (class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer = InputHtmlRenderer.class$("org.apache.myfaces.custom.inputHtml.InputHtmlRenderer")) : class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer, "kupueditor.js", context);
        AddResource.addJavaScriptToHeader(class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer == null ? (class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer = InputHtmlRenderer.class$("org.apache.myfaces.custom.inputHtml.InputHtmlRenderer")) : class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer, "kupubasetools.js", context);
        AddResource.addJavaScriptToHeader(class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer == null ? (class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer = InputHtmlRenderer.class$("org.apache.myfaces.custom.inputHtml.InputHtmlRenderer")) : class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer, "kupuloggers.js", context);
        AddResource.addJavaScriptToHeader(class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer == null ? (class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer = InputHtmlRenderer.class$("org.apache.myfaces.custom.inputHtml.InputHtmlRenderer")) : class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer, "kupunoi18n.js", context);
        AddResource.addJavaScriptToHeader(class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer == null ? (class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer = InputHtmlRenderer.class$("org.apache.myfaces.custom.inputHtml.InputHtmlRenderer")) : class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer, "kupucleanupexpressions.js", context);
        AddResource.addJavaScriptToHeader(class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer == null ? (class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer = InputHtmlRenderer.class$("org.apache.myfaces.custom.inputHtml.InputHtmlRenderer")) : class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer, "kupucontentfilters.js", context);
        if (editor.isShowAnyToolBox()) {
            AddResource.addJavaScriptToHeader(class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer == null ? (class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer = InputHtmlRenderer.class$("org.apache.myfaces.custom.inputHtml.InputHtmlRenderer")) : class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer, "kuputoolcollapser.js", context);
        }
        AddResource.addJavaScriptToHeader(class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer == null ? (class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer = InputHtmlRenderer.class$("org.apache.myfaces.custom.inputHtml.InputHtmlRenderer")) : class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer, "kupucontextmenu.js", context);
        AddResource.addJavaScriptToHeader(class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer == null ? (class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer = InputHtmlRenderer.class$("org.apache.myfaces.custom.inputHtml.InputHtmlRenderer")) : class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer, "kupuinit.js", context);
        AddResource.addJavaScriptToHeader(class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer == null ? (class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer = InputHtmlRenderer.class$("org.apache.myfaces.custom.inputHtml.InputHtmlRenderer")) : class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer, "kupustart.js", context);
        AddResource.addJavaScriptToHeader(class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer == null ? (class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer = InputHtmlRenderer.class$("org.apache.myfaces.custom.inputHtml.InputHtmlRenderer")) : class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer, "kupusourceedit.js", context);
        AddResource.addJavaScriptToHeader(class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer == null ? (class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer = InputHtmlRenderer.class$("org.apache.myfaces.custom.inputHtml.InputHtmlRenderer")) : class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer, "kupuspellchecker.js", context);
        AddResource.addJavaScriptToHeader(class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer == null ? (class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer = InputHtmlRenderer.class$("org.apache.myfaces.custom.inputHtml.InputHtmlRenderer")) : class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer, "kupudrawers.js", context);
        AddResource.addJavaScriptToHeader(class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer == null ? (class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer = InputHtmlRenderer.class$("org.apache.myfaces.custom.inputHtml.InputHtmlRenderer")) : class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer, "myFacesUtils.js", context);
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", editor);
        writer.writeAttribute("style", "display: none;", null);
        writer.startElement("xml", editor);
        writer.writeAttribute("id", "kupuconfig", null);
        writer.writeAttribute("class", "kupuconfig", null);
        writer.startElement("kupuconfig", editor);
        InputHtmlRenderer.writeTag(writer, "dst", "fulldoc.html", editor);
        InputHtmlRenderer.writeTag(writer, "use_css", "1", editor);
        InputHtmlRenderer.writeTag(writer, "reload_after_save", "0", editor);
        InputHtmlRenderer.writeTag(writer, "strict_output", "1", editor);
        InputHtmlRenderer.writeTag(writer, "content_type", "application/xhtml+xml", editor);
        InputHtmlRenderer.writeTag(writer, "compatible_singletons", "1", editor);
        writer.startElement("table_classes", editor);
        InputHtmlRenderer.writeTag(writer, "class", "plain", editor);
        InputHtmlRenderer.writeTag(writer, "class", "listing", editor);
        InputHtmlRenderer.writeTag(writer, "class", "grid", editor);
        InputHtmlRenderer.writeTag(writer, "class", "data", editor);
        writer.endElement("table_classes");
        writer.startElement("cleanup_expressions", editor);
        writer.startElement("set", editor);
        writer.startElement("name", editor);
        writer.write("Convert single quotes to curly ones");
        writer.endElement("name");
        writer.startElement("expression", editor);
        writer.startElement("reg", editor);
        writer.write("(\\W)'");
        writer.endElement("reg");
        writer.startElement("replacement", editor);
        writer.write("\\1&#x8216;");
        writer.endElement("replacement");
        writer.endElement("expression");
        writer.startElement("expression", editor);
        writer.startElement("reg", editor);
        writer.write("'");
        writer.endElement("reg");
        writer.startElement("replacement", editor);
        writer.write("&#x8217;");
        writer.endElement("replacement");
        writer.endElement("expression");
        writer.endElement("set");
        writer.startElement("set", editor);
        writer.startElement("name", editor);
        writer.write("Reduce whitespace");
        writer.endElement("name");
        writer.startElement("expression", editor);
        writer.startElement("reg", editor);
        writer.write("[\\n\\r\\t]");
        writer.endElement("reg");
        writer.startElement("replacement", editor);
        writer.write("\\x20");
        writer.endElement("replacement");
        writer.endElement("expression");
        writer.startElement("expression", editor);
        writer.startElement("reg", editor);
        writer.write("[ ]{2}");
        writer.endElement("reg");
        writer.startElement("replacement", editor);
        writer.write("\\x20");
        writer.endElement("replacement");
        writer.endElement("expression");
        writer.endElement("set");
        writer.endElement("cleanup_expressions");
        InputHtmlRenderer.writeTag(writer, "image_xsl_uri", AddResource.getResourceMappedPath(class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer == null ? (class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer = InputHtmlRenderer.class$("org.apache.myfaces.custom.inputHtml.InputHtmlRenderer")) : class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer, "kupudrawers/drawer.xsl", context), editor);
        InputHtmlRenderer.writeTag(writer, "link_xsl_uri", AddResource.getResourceMappedPath(class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer == null ? (class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer = InputHtmlRenderer.class$("org.apache.myfaces.custom.inputHtml.InputHtmlRenderer")) : class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer, "kupudrawers/drawer.xsl", context), editor);
        InputHtmlRenderer.writeTag(writer, "image_libraries_uri", AddResource.getResourceMappedPath(class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer == null ? (class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer = InputHtmlRenderer.class$("org.apache.myfaces.custom.inputHtml.InputHtmlRenderer")) : class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer, "kupudrawers/imagelibrary.xml", context), editor);
        InputHtmlRenderer.writeTag(writer, "link_libraries_uri", AddResource.getResourceMappedPath(class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer == null ? (class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer = InputHtmlRenderer.class$("org.apache.myfaces.custom.inputHtml.InputHtmlRenderer")) : class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer, "kupudrawers/linklibrary.xml", context), editor);
        InputHtmlRenderer.writeTag(writer, "search_images_uri", "", editor);
        InputHtmlRenderer.writeTag(writer, "search_links_uri", "", editor);
        writer.endElement("kupuconfig");
        writer.endElement("xml");
        writer.endElement("div");
        writer.startElement("div", editor);
        writer.writeAttribute("class", "kupu-fulleditor", null);
        writer.startElement("div", editor);
        writer.writeAttribute("class", "kupu-tb", null);
        writer.writeAttribute("id", "toolbar", null);
        writer.startElement("span", editor);
        writer.writeAttribute("id", "kupu-tb-buttons", null);
        writer.writeAttribute("class", "kupu-tb-buttons", null);
        writer.startElement("span", editor);
        writer.writeAttribute("class", "kupu-tb-buttongroup", null);
        writer.writeAttribute("id", "kupu-logo", null);
        writer.writeAttribute("style", "float: right", null);
        writer.startElement("button", null);
        writer.writeAttribute("type", "button", null);
        writer.writeAttribute("class", "kupu-zoom", null);
        writer.writeAttribute("id", "kupu-zoom-button", null);
        writer.writeAttribute("title", "zoom: alt-x", null);
        writer.writeAttribute("i18n:attributes", "title", null);
        writer.writeAttribute("accesskey", "x", null);
        writer.write(" ");
        writer.endElement("button");
        if (editor.isAddKupuLogo()) {
            writer.startElement("button", editor);
            writer.writeAttribute("type", "button", null);
            writer.writeAttribute("class", "kupu-logo", null);
            writer.writeAttribute("title", "Kupu 1.3", null);
            writer.writeAttribute("i18n:attributes", "title", null);
            writer.writeAttribute("accesskey", "k", null);
            writer.writeAttribute("onclick", "window.open('http://kupu.oscom.org');", null);
            writer.write(" ");
            writer.endElement("button");
        }
        writer.endElement("span");
        writer.startElement("select", editor);
        writer.writeAttribute("id", "kupu-tb-styles", null);
        writer.startElement("option", editor);
        writer.writeAttribute("xmlns:i18n", "http://xml.zope.org/namespaces/i18n", null);
        writer.writeAttribute("value", "P", null);
        writer.writeAttribute("i18n:translate", "paragraph-normal", null);
        writer.write("Normal");
        writer.endElement("option");
        writer.startElement("option", editor);
        writer.writeAttribute("value", "H1", null);
        writer.startElement("span", editor);
        writer.writeAttribute("xmlns:i18n", "http://xml.zope.org/namespaces/i18n", null);
        writer.writeAttribute("i18n:translate", "heading", null);
        writer.write("Heading");
        writer.endElement("span");
        writer.write(" 1");
        writer.endElement("option");
        writer.startElement("option", editor);
        writer.writeAttribute("value", "H2", null);
        writer.startElement("span", editor);
        writer.writeAttribute("xmlns:i18n", "http://xml.zope.org/namespaces/i18n", null);
        writer.writeAttribute("i18n:translate", "heading", null);
        writer.write("Heading");
        writer.endElement("span");
        writer.write(" 2");
        writer.endElement("option");
        writer.startElement("option", editor);
        writer.writeAttribute("value", "H3", null);
        writer.startElement("span", editor);
        writer.writeAttribute("xmlns:i18n", "http://xml.zope.org/namespaces/i18n", null);
        writer.writeAttribute("i18n:translate", "heading", null);
        writer.write("Heading");
        writer.endElement("span");
        writer.write(" 3");
        writer.endElement("option");
        writer.startElement("option", editor);
        writer.writeAttribute("value", "H4", null);
        writer.startElement("span", editor);
        writer.writeAttribute("xmlns:i18n", "http://xml.zope.org/namespaces/i18n", null);
        writer.writeAttribute("i18n:translate", "heading", null);
        writer.write("Heading");
        writer.endElement("span");
        writer.write(" 4");
        writer.endElement("option");
        writer.startElement("option", editor);
        writer.writeAttribute("value", "H5", null);
        writer.startElement("span", editor);
        writer.writeAttribute("xmlns:i18n", "http://xml.zope.org/namespaces/i18n", null);
        writer.writeAttribute("i18n:translate", "heading", null);
        writer.write("Heading");
        writer.endElement("span");
        writer.write(" 5");
        writer.endElement("option");
        writer.startElement("option", editor);
        writer.writeAttribute("value", "H6", null);
        writer.startElement("span", editor);
        writer.writeAttribute("xmlns:i18n", "http://xml.zope.org/namespaces/i18n", null);
        writer.writeAttribute("i18n:translate", "heading", null);
        writer.write("Heading");
        writer.endElement("span");
        writer.write(" 6");
        writer.endElement("option");
        writer.startElement("option", editor);
        writer.writeAttribute("xmlns:i18n", "http://xml.zope.org/namespaces/i18n", null);
        writer.writeAttribute("value", "PRE", null);
        writer.writeAttribute("i18n:translate", "paragraph-formatted", null);
        writer.write("Formatted");
        writer.endElement("option");
        writer.endElement("select");
        writer.startElement("span", editor);
        writer.writeAttribute("class", "kupu-tb-buttongroup", null);
        writer.writeAttribute("style", "display: none", null);
        InputHtmlRenderer.writeButton(writer, "kupu-save", "Save", "s", editor);
        writer.endElement("span");
        writer.startElement("span", editor);
        writer.writeAttribute("class", "kupu-tb-buttongroup", null);
        writer.writeAttribute("id", "kupu-bg-basicmarkup", null);
        InputHtmlRenderer.writeButton(writer, "kupu-bold", "bold: alt-b", "b", editor);
        InputHtmlRenderer.writeButton(writer, "kupu-italic", "italic: alt-i", "i", editor);
        InputHtmlRenderer.writeButton(writer, "kupu-underline", "underline: alt-u", "u", editor);
        writer.endElement("span");
        writer.startElement("span", editor);
        writer.writeAttribute("class", "kupu-tb-buttongroup", null);
        writer.writeAttribute("id", "kupu-bg-subsuper", null);
        InputHtmlRenderer.writeButton(writer, "kupu-subscript", "subscript: alt--", "-", editor);
        InputHtmlRenderer.writeButton(writer, "kupu-superscript", "superscript: alt-+", "+", editor);
        writer.endElement("span");
        writer.startElement("span", editor);
        writer.writeAttribute("class", "kupu-tb-buttongroup", null);
        InputHtmlRenderer.writeButton(writer, "kupu-forecolor", "text color: alt-f", "f", editor);
        InputHtmlRenderer.writeButton(writer, "kupu-hilitecolor", "background color: alt-h", "h", editor);
        writer.endElement("span");
        writer.startElement("span", editor);
        writer.writeAttribute("class", "kupu-tb-buttongroup", null);
        writer.writeAttribute("id", "kupu-bg-justify", null);
        InputHtmlRenderer.writeButton(writer, "kupu-justifyleft", "left justify: alt-l", "l", editor);
        InputHtmlRenderer.writeButton(writer, "kupu-justifycenter", "center justify: alt-c", "c", editor);
        InputHtmlRenderer.writeButton(writer, "kupu-justifyright", "right justify: alt-r", "r", editor);
        writer.endElement("span");
        writer.startElement("span", editor);
        writer.writeAttribute("class", "kupu-tb-buttongroup", null);
        writer.writeAttribute("id", "kupu-bg-list", null);
        InputHtmlRenderer.writeButton(writer, "kupu-insertorderedlist", "numbered list: alt-#", "#", "kupu-list-ol-addbutton", editor);
        InputHtmlRenderer.writeButton(writer, "kupu-insertunorderedlist", "unordered list: alt-*", "*", "kupu-list-ul-addbutton", editor);
        writer.endElement("span");
        writer.startElement("span", editor);
        writer.writeAttribute("class", "kupu-tb-buttongroup", null);
        writer.writeAttribute("id", "kupu-bg-definitionlist", null);
        InputHtmlRenderer.writeButton(writer, "kupu-insertdefinitionlist", "definition list: alt-=", "=", "kupu-list-dl-addbutton", editor);
        writer.endElement("span");
        writer.startElement("span", editor);
        writer.writeAttribute("class", "kupu-tb-buttongroup", null);
        writer.writeAttribute("id", "kupu-bg-indent", null);
        InputHtmlRenderer.writeButton(writer, "kupu-outdent", "outdent: alt-<", "<", editor);
        InputHtmlRenderer.writeButton(writer, "kupu-indent", "indent: alt->", ">", editor);
        writer.endElement("span");
        writer.startElement("span", editor);
        writer.writeAttribute("class", "kupu-tb-buttongroup", null);
        if (!editor.isAllowExternalLinks()) {
            writer.writeAttribute("style", "display: none", null);
        }
        InputHtmlRenderer.writeButton(writer, "kupu-image", "image", null, "kupu-imagelibdrawer-button", false, editor);
        InputHtmlRenderer.writeButton(writer, "kupu-inthyperlink", "link", null, "kupu-linklibdrawer-button", false, editor);
        InputHtmlRenderer.writeButton(writer, "kupu-exthyperlink", "external link", null, "kupu-linkdrawer-button", editor);
        InputHtmlRenderer.writeButton(writer, "kupu-table", "table", null, "kupu-tabledrawer-button", editor);
        writer.endElement("span");
        writer.startElement("span", editor);
        writer.writeAttribute("class", "kupu-tb-buttongroup", null);
        writer.writeAttribute("id", "kupu-bg-remove", null);
        InputHtmlRenderer.writeButton(writer, "kupu-removeimage invisible", "Remove image", null, "kupu-removeimage-button", editor);
        InputHtmlRenderer.writeButton(writer, "kupu-removelink invisible", "Remove link", null, "kupu-removelink-button", editor);
        writer.endElement("span");
        writer.startElement("span", editor);
        writer.writeAttribute("class", "kupu-tb-buttongroup", null);
        writer.writeAttribute("id", "kupu-bg-undo", null);
        InputHtmlRenderer.writeButton(writer, "kupu-undo", "undo: alt-z", "z", editor);
        InputHtmlRenderer.writeButton(writer, "kupu-redo", "redo: alt-y", "y", editor);
        writer.endElement("span");
        writer.startElement("span", editor);
        writer.writeAttribute("class", "kupu-tb-buttongroup kupu-spellchecker-span", null);
        writer.writeAttribute("id", "kupu-spellchecker", null);
        writer.writeAttribute("style", "display: none", null);
        InputHtmlRenderer.writeButton(writer, "kupu-spellchecker", "check spelling", null, editor);
        writer.endElement("span");
        writer.startElement("span", editor);
        writer.writeAttribute("class", "kupu-tb-buttongroup kupu-source-span", null);
        writer.writeAttribute("id", "kupu-source", null);
        if (!editor.isAllowEditSource()) {
            writer.writeAttribute("style", "display: none", null);
        }
        InputHtmlRenderer.writeButton(writer, "kupu-source", "edit HTML code", null, editor);
        writer.endElement("span");
        writer.endElement("span");
        writer.startElement("select", editor);
        writer.writeAttribute("id", "kupu-ulstyles", null);
        writer.writeAttribute("class", "kupu-ulstyles", null);
        InputHtmlRenderer.writeOption(writer, "disc", "list-disc", "&#x25CF;", editor);
        InputHtmlRenderer.writeOption(writer, "square", "list-square", "&#x25A0;", editor);
        InputHtmlRenderer.writeOption(writer, "circle", "list-circle", "&#x25CB;", editor);
        InputHtmlRenderer.writeOption(writer, "none", "list-nobullet", "no bullet", editor);
        writer.endElement("select");
        writer.startElement("select", editor);
        writer.writeAttribute("id", "kupu-olstyles", null);
        writer.writeAttribute("class", "kupu-olstyles", null);
        InputHtmlRenderer.writeOption(writer, "decimal", "list-decimal", "1", editor);
        InputHtmlRenderer.writeOption(writer, "upper-roman", "list-upperroman", "I", editor);
        InputHtmlRenderer.writeOption(writer, "lower-roman", "list-lowerroman", "i", editor);
        InputHtmlRenderer.writeOption(writer, "upper-alpha", "list-upperalpha", "A", editor);
        InputHtmlRenderer.writeOption(writer, "lower-alpha", "list-loweralpha", "a", editor);
        writer.endElement("select");
        writer.startElement("div", editor);
        writer.writeAttribute("style", "display:block;", null);
        writer.writeAttribute("class", "kupu-librarydrawer-parent", null);
        writer.endElement("div");
        writer.startElement("div", editor);
        writer.writeAttribute("id", "kupu-linkdrawer", null);
        writer.writeAttribute("class", "kupu-drawer kupu-linkdrawer", null);
        writer.startElement("h1", editor);
        writer.writeAttribute("xmlns:i18n", "http://xml.zope.org/namespaces/i18n", null);
        writer.writeAttribute("i18n:translate", "", null);
        writer.write("External Link");
        writer.endElement("h1");
        writer.startElement("div", editor);
        writer.writeAttribute("id", "kupu-linkdrawer-addlink", null);
        writer.writeAttribute("class", "kupu-panels kupu-linkdrawer-addlink", null);
        writer.startElement("table", editor);
        writer.writeAttribute("cellspacing", "0", null);
        writer.startElement("tr", editor);
        writer.startElement("td", editor);
        writer.startElement("div", editor);
        writer.writeAttribute("id", "kupu-toolbox-label", null);
        writer.startElement("span", editor);
        writer.writeAttribute("xmlns:i18n", "http://xml.zope.org/namespaces/i18n", null);
        writer.writeAttribute("i18n:translate", "items-matching-keyword", null);
        writer.write("Link the highlighted text to this URL:");
        writer.endElement("span");
        writer.endElement("div");
        writer.startElement("input", editor);
        writer.writeAttribute("class", "kupu-toolbox-st kupu-linkdrawer-input", null);
        writer.writeAttribute("type", "text", null);
        writer.writeAttribute("onkeypress", "return HandleDrawerEnter(event, 'linkdrawer-preview');", null);
        writer.endElement("input");
        writer.endElement("td");
        writer.startElement("td", null);
        writer.writeAttribute("class", "kupu-preview-button", null);
        writer.startElement("button", editor);
        writer.writeAttribute("class", "kupu-dialog-button", null);
        writer.writeAttribute("type", "button", null);
        writer.writeAttribute("onclick", "drawertool.current_drawer.preview()", null);
        writer.write("Preview");
        writer.endElement("button");
        writer.endElement("td");
        writer.endElement("tr");
        writer.startElement("tr", editor);
        writer.startElement("td", editor);
        writer.writeAttribute("colspan", "2", null);
        writer.writeAttribute("align", "center", null);
        writer.startElement("iframe", editor);
        writer.writeAttribute("frameborder", "1", null);
        writer.writeAttribute("scrolling", "auto", null);
        writer.writeAttribute("width", "440", null);
        writer.writeAttribute("height", "198", null);
        writer.writeAttribute("class", "kupu-linkdrawer-preview", null);
        writer.writeAttribute("src", AddResource.getResourceMappedPath(class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer == null ? (class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer = InputHtmlRenderer.class$("org.apache.myfaces.custom.inputHtml.InputHtmlRenderer")) : class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer, "kupublank.html", context), null);
        writer.endElement("iframe");
        writer.endElement("td");
        writer.endElement("tr");
        writer.endElement("table");
        writer.startElement("div", editor);
        writer.writeAttribute("class", "kupu-dialogbuttons", null);
        writer.startElement("button", editor);
        writer.writeAttribute("type", "button", null);
        writer.writeAttribute("class", "kupu-dialog-button", null);
        writer.writeAttribute("onclick", "drawertool.current_drawer.save()", null);
        writer.write("Ok");
        writer.endElement("button");
        writer.startElement("button", editor);
        writer.writeAttribute("type", "button", null);
        writer.writeAttribute("class", "kupu-dialog-button", null);
        writer.writeAttribute("onclick", "drawertool.closeDrawer()", null);
        writer.write("Cancel");
        writer.endElement("button");
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("div");
        writer.startElement("div", editor);
        writer.writeAttribute("id", "kupu-tabledrawer", null);
        writer.writeAttribute("class", "kupu-drawer kupu-tabledrawer", null);
        writer.startElement("h1", editor);
        writer.write("Table");
        writer.endElement("h1");
        writer.startElement("div", editor);
        writer.writeAttribute("class", "kupu-panels", null);
        writer.startElement("table", editor);
        writer.writeAttribute("width", "300", null);
        writer.startElement("tr", editor);
        writer.writeAttribute("class", "kupu-panelsrow", null);
        writer.startElement("td", editor);
        writer.writeAttribute("class", "kupu-panel", null);
        writer.startElement("div", editor);
        writer.writeAttribute("class", "kupu-tabledrawer-addtable", null);
        writer.startElement("table", editor);
        writer.startElement("tr", editor);
        writer.startElement("th", editor);
        writer.writeAttribute("class", "kupu-toolbox-label", null);
        writer.write("Table Class");
        writer.endElement("th");
        writer.startElement("td", editor);
        writer.startElement("select", editor);
        writer.writeAttribute("class", "kupu-tabledrawer-addclasschooser", null);
        InputHtmlRenderer.writeOption(writer, "plain", "Plain", editor);
        InputHtmlRenderer.writeOption(writer, "listing", "Listing", editor);
        InputHtmlRenderer.writeOption(writer, "grid", "Grid", editor);
        InputHtmlRenderer.writeOption(writer, "data", "Data", editor);
        writer.endElement("select");
        writer.endElement("td");
        writer.endElement("tr");
        writer.startElement("tr", editor);
        writer.startElement("th", editor);
        writer.writeAttribute("class", "kupu-toolbox-label", null);
        writer.write("Rows");
        writer.endElement("th");
        writer.startElement("td", editor);
        writer.startElement("input", editor);
        writer.writeAttribute("type", "text", null);
        writer.writeAttribute("class", "kupu-tabledrawer-newrows", null);
        writer.writeAttribute("value", "3", null);
        writer.writeAttribute("onkeypress", "return HandleDrawerEnter(event);", null);
        writer.endElement("input");
        writer.endElement("td");
        writer.endElement("tr");
        writer.startElement("tr", editor);
        writer.startElement("th", editor);
        writer.writeAttribute("class", "kupu-toolbox-label", null);
        writer.write("Columns");
        writer.endElement("th");
        writer.startElement("td", editor);
        writer.startElement("input", editor);
        writer.writeAttribute("type", "text", null);
        writer.writeAttribute("class", "kupu-tabledrawer-newcols", null);
        writer.writeAttribute("value", "3", null);
        writer.writeAttribute("onkeypress", "return HandleDrawerEnter(event);", null);
        writer.endElement("input");
        writer.endElement("td");
        writer.endElement("tr");
        writer.startElement("tr", editor);
        writer.startElement("th", editor);
        writer.writeAttribute("class", "kupu-toolbox-label", null);
        writer.endElement("th");
        writer.startElement("td", editor);
        writer.startElement("label", editor);
        writer.startElement("input", editor);
        writer.writeAttribute("type", "checkbox", null);
        writer.writeAttribute("class", "kupu-tabledrawer-makeheader", null);
        writer.writeAttribute("onkeypress", "return HandleDrawerEnter(event);", null);
        writer.endElement("input");
        writer.startElement("span", editor);
        writer.write("Create Headings");
        writer.endElement("span");
        writer.endElement("label");
        writer.endElement("td");
        writer.endElement("tr");
        writer.startElement("tr", editor);
        writer.startElement("th", editor);
        writer.writeAttribute("class", "kupu-toolbox-label", null);
        writer.endElement("th");
        writer.startElement("td", editor);
        writer.startElement("button", editor);
        writer.writeAttribute("type", "button", null);
        writer.writeAttribute("class", "kupu-dialog-button", null);
        writer.writeAttribute("onclick", "drawertool.current_drawer.createTable()", null);
        writer.write("Add Table");
        writer.endElement("button");
        writer.startElement("button", editor);
        writer.writeAttribute("type", "button", null);
        writer.writeAttribute("class", "kupu-dialog-button", null);
        writer.writeAttribute("onclick", "drawertool.current_drawer.fixAllTables()", null);
        writer.write("Fix All Tables");
        writer.endElement("button");
        writer.endElement("td");
        writer.endElement("tr");
        writer.endElement("table");
        writer.endElement("div");
        writer.startElement("div", editor);
        writer.writeAttribute("class", "kupu-tabledrawer-edittable", null);
        writer.startElement("table", editor);
        writer.startElement("tr", editor);
        writer.startElement("th", editor);
        writer.writeAttribute("class", "kupu-toolbox-label", null);
        writer.write("Table Class");
        writer.endElement("th");
        writer.startElement("td", editor);
        writer.startElement("select", editor);
        writer.writeAttribute("class", "kupu-tabledrawer-editclasschooser", null);
        writer.writeAttribute("onchange", "drawertool.current_drawer.setTableClass(this.options[this.selectedIndex].value)", null);
        InputHtmlRenderer.writeOption(writer, "plain", "Plain", editor);
        InputHtmlRenderer.writeOption(writer, "listing", "Listing", editor);
        InputHtmlRenderer.writeOption(writer, "grid", "Grid", editor);
        InputHtmlRenderer.writeOption(writer, "data", "Data", editor);
        writer.endElement("select");
        writer.endElement("td");
        writer.endElement("tr");
        writer.startElement("tr", editor);
        writer.startElement("th", editor);
        writer.writeAttribute("class", "kupu-toolbox-label", null);
        writer.write("Current column alignment");
        writer.endElement("th");
        writer.startElement("td", editor);
        writer.startElement("select", editor);
        writer.writeAttribute("class", "kupu-tabledrawer-alignchooser", null);
        writer.writeAttribute("onchange", "drawertool.current_drawer.tool.setColumnAlign(this.options[this.selectedIndex].value)", null);
        InputHtmlRenderer.writeOption(writer, "left", "Left", editor);
        InputHtmlRenderer.writeOption(writer, "center", "Center", editor);
        InputHtmlRenderer.writeOption(writer, "right", "Right", editor);
        writer.endElement("select");
        writer.endElement("td");
        writer.endElement("tr");
        writer.startElement("tr", editor);
        writer.startElement("th", editor);
        writer.writeAttribute("class", "kupu-toolbox-label", null);
        writer.write("Column");
        writer.endElement("th");
        writer.startElement("td", editor);
        writer.startElement("button", editor);
        writer.writeAttribute("type", "button", null);
        writer.writeAttribute("class", "kupu-dialog-button", null);
        writer.writeAttribute("onclick", "drawertool.current_drawer.addTableColumn()", null);
        writer.write("Add");
        writer.endElement("button");
        writer.startElement("button", editor);
        writer.writeAttribute("type", "button", null);
        writer.writeAttribute("class", "kupu-dialog-button", null);
        writer.writeAttribute("onclick", "drawertool.current_drawer.delTableColumn()", null);
        writer.write("Remove");
        writer.endElement("button");
        writer.endElement("td");
        writer.endElement("tr");
        writer.startElement("tr", editor);
        writer.startElement("th", editor);
        writer.writeAttribute("class", "kupu-toolbox-label", null);
        writer.write("Row");
        writer.endElement("th");
        writer.startElement("td", editor);
        writer.startElement("button", editor);
        writer.writeAttribute("type", "button", null);
        writer.writeAttribute("class", "kupu-dialog-button", null);
        writer.writeAttribute("onclick", "drawertool.current_drawer.addTableRow()", null);
        writer.write("Add");
        writer.endElement("button");
        writer.startElement("button", editor);
        writer.writeAttribute("type", "button", null);
        writer.writeAttribute("class", "kupu-dialog-button", null);
        writer.writeAttribute("onclick", "drawertool.current_drawer.delTableRow()", null);
        writer.write("Remove");
        writer.endElement("button");
        writer.endElement("td");
        writer.endElement("tr");
        writer.startElement("tr", editor);
        writer.startElement("th", editor);
        writer.writeAttribute("class", "kupu-toolbox-label", null);
        writer.write("Fix Table");
        writer.endElement("th");
        writer.startElement("td", editor);
        writer.startElement("button", editor);
        writer.writeAttribute("type", "button", null);
        writer.writeAttribute("class", "kupu-dialog-button", null);
        writer.writeAttribute("onclick", "drawertool.current_drawer.fixTable()", null);
        writer.write("Fix");
        writer.endElement("button");
        writer.endElement("td");
        writer.endElement("tr");
        writer.endElement("table");
        writer.endElement("div");
        writer.endElement("td");
        writer.endElement("tr");
        writer.endElement("table");
        writer.startElement("div", editor);
        writer.writeAttribute("class", "kupu-dialogbuttons", null);
        writer.startElement("button", editor);
        writer.writeAttribute("type", "button", null);
        writer.writeAttribute("class", "kupu-dialog-button", null);
        writer.writeAttribute("onmousedown", "window.status ='onmousedown';", null);
        writer.writeAttribute("onclick", "drawertool.closeDrawer(this)", null);
        writer.writeAttribute("onfocus", "window.status='focus';", null);
        writer.write("Close");
        writer.endElement("button");
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("div");
        writer.startElement("div", editor);
        writer.writeAttribute("class", "kupu-toolboxes", null);
        writer.writeAttribute("id", "kupu-toolboxes", null);
        if (!editor.isShowAnyToolBox()) {
            writer.writeAttribute("style", "display: none", null);
        }
        writer.startElement("div", editor);
        writer.writeAttribute("class", "kupu-toolbox", null);
        writer.writeAttribute("id", "kupu-toolbox-properties", null);
        if (!editor.isShowPropertiesToolBox()) {
            writer.writeAttribute("style", "display: none", null);
        }
        writer.startElement("h1", editor);
        writer.writeAttribute("class", "kupu-toolbox-heading", null);
        writer.write("Properties");
        writer.endElement("h1");
        writer.startElement("div", editor);
        writer.startElement("div", editor);
        writer.writeAttribute("class", "kupu-toolbox-label", null);
        writer.write("Title:");
        writer.endElement("div");
        writer.startElement("input", editor);
        writer.writeAttribute("class", "wide", null);
        writer.writeAttribute("id", "kupu-properties-title", null);
        writer.endElement("input");
        writer.startElement("div", editor);
        writer.writeAttribute("class", "kupu-toolbox-label", null);
        writer.write("Description:");
        writer.endElement("div");
        writer.startElement("textarea", editor);
        writer.writeAttribute("class", "wide", null);
        writer.writeAttribute("id", "kupu-properties-description", null);
        writer.endElement("textarea");
        writer.endElement("div");
        writer.endElement("div");
        writer.startElement("div", editor);
        writer.writeAttribute("class", "kupu-toolbox", null);
        writer.writeAttribute("id", "kupu-toolbox-links", null);
        if (!editor.isShowLinksToolBox()) {
            writer.writeAttribute("style", "display: none", null);
        }
        writer.startElement("h1", editor);
        writer.writeAttribute("class", "kupu-toolbox-heading", null);
        writer.writeAttribute("i18n:translate", "links", null);
        writer.write("Links");
        writer.endElement("h1");
        writer.startElement("div", editor);
        writer.writeAttribute("class", "kupu-toolbox-addlink", null);
        writer.startElement("div", editor);
        writer.writeAttribute("class", "kupu-toolbox-label", null);
        writer.startElement("span", editor);
        writer.writeAttribute("xmlns:i18n", "http://xml.zope.org/namespaces/i18n", null);
        writer.writeAttribute("i18n:translate", "items-matching-keyword", null);
        writer.write("Link the highlighted text to this URL:");
        writer.endElement("span");
        writer.endElement("div");
        writer.startElement("input", editor);
        writer.writeAttribute("id", "kupu-link-input", null);
        writer.writeAttribute("class", "wide", null);
        writer.writeAttribute("type", "text", null);
        writer.endElement("input");
        writer.startElement("div", editor);
        writer.writeAttribute("class", "kupu-toolbox-buttons", null);
        writer.startElement("button", editor);
        writer.writeAttribute("type", "button", null);
        writer.writeAttribute("id", "kupu-link-button", null);
        writer.writeAttribute("class", "kupu-toolbox-action", null);
        writer.write("Make Link");
        writer.endElement("button");
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("div");
        writer.startElement("div", editor);
        writer.writeAttribute("class", "kupu-toolbox", null);
        writer.writeAttribute("id", "kupu-toolbox-images", null);
        if (!editor.isShowImagesToolBox()) {
            writer.writeAttribute("style", "display: none", null);
        }
        writer.startElement("h1", editor);
        writer.writeAttribute("class", "kupu-toolbox-heading", null);
        writer.writeAttribute("i18n:translate", "images", null);
        writer.write("Images");
        writer.endElement("h1");
        writer.startElement("div", editor);
        writer.startElement("div", editor);
        writer.writeAttribute("class", "kupu-toolbox-label", null);
        writer.startElement("span", editor);
        writer.writeAttribute("xmlns:i18n", "http://xml.zope.org/namespaces/i18n", null);
        writer.writeAttribute("i18n:translate", "", null);
        writer.write("Image float:");
        writer.endElement("span");
        writer.endElement("div");
        writer.startElement("select", editor);
        writer.writeAttribute("class", "wide", null);
        writer.writeAttribute("id", "kupu-image-float-select", null);
        InputHtmlRenderer.writeOption(writer, "image-inline", "Inline", editor);
        InputHtmlRenderer.writeOption(writer, "image-left", "Left", editor);
        InputHtmlRenderer.writeOption(writer, "image-right", "Right", editor);
        writer.endElement("select");
        writer.startElement("div", editor);
        writer.writeAttribute("class", "kupu-toolbox-label", null);
        writer.startElement("span", editor);
        writer.writeAttribute("xmlns:i18n", "http://xml.zope.org/namespaces/i18n", null);
        writer.writeAttribute("i18n:translate", "", null);
        writer.write("Insert image at the following URL:");
        writer.endElement("span");
        writer.endElement("div");
        writer.startElement("input", editor);
        writer.writeAttribute("id", "kupu-image-input", null);
        writer.writeAttribute("value", "kupuimages/kupu_icon.gif", null);
        writer.writeAttribute("class", "wide", null);
        writer.writeAttribute("type", "text", null);
        writer.endElement("input");
        writer.startElement("div", editor);
        writer.writeAttribute("class", "kupu-toolbox-buttons", null);
        writer.startElement("button", editor);
        writer.writeAttribute("type", "button", null);
        writer.writeAttribute("id", "kupu-image-addbutton", null);
        writer.writeAttribute("class", "kupu-toolbox-action", null);
        writer.write("Insert Image");
        writer.endElement("button");
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("div");
        writer.startElement("div", editor);
        writer.writeAttribute("class", "kupu-toolbox", null);
        writer.writeAttribute("id", "kupu-toolbox-tables", null);
        if (!editor.isShowTablesToolBox()) {
            writer.writeAttribute("style", "display: none", null);
        }
        writer.startElement("h1", editor);
        writer.writeAttribute("class", "kupu-toolbox-heading", null);
        writer.writeAttribute("i18n:translate", "table-inspector", null);
        writer.write("Tables");
        writer.endElement("h1");
        writer.startElement("div", editor);
        writer.startElement("div", editor);
        writer.writeAttribute("class", "kupu-toolbox-label", null);
        writer.startElement("span", editor);
        writer.write("Table Class:");
        writer.endElement("span");
        writer.startElement("select", editor);
        writer.writeAttribute("class", "wide", null);
        writer.writeAttribute("id", "kupu-table-classchooser", null);
        writer.write(32);
        writer.endElement("select");
        writer.endElement("div");
        writer.startElement("div", editor);
        writer.writeAttribute("id", "kupu-toolbox-addtable", null);
        writer.writeAttribute("class", "kupu-toolbox-addtable", null);
        writer.startElement("div", editor);
        writer.writeAttribute("class", "kupu-toolbox-label", null);
        writer.write("Rows:");
        writer.endElement("div");
        writer.startElement("input", editor);
        writer.writeAttribute("class", "wide", null);
        writer.writeAttribute("type", "text", null);
        writer.writeAttribute("id", "kupu-table-newrows", null);
        writer.endElement("input");
        writer.startElement("div", editor);
        writer.writeAttribute("class", "kupu-toolbox-label", null);
        writer.write("Columns:");
        writer.endElement("div");
        writer.startElement("input", editor);
        writer.writeAttribute("class", "wide", null);
        writer.writeAttribute("type", "text", null);
        writer.writeAttribute("id", "kupu-table-newcols", null);
        writer.endElement("input");
        writer.startElement("div", editor);
        writer.writeAttribute("class", "kupu-toolbox-label", null);
        writer.write("Headings:");
        writer.startElement("input", editor);
        writer.writeAttribute("name", "kupu-table-makeheader", null);
        writer.writeAttribute("id", "kupu-table-makeheader", null);
        writer.writeAttribute("type", "checkbox", null);
        writer.endElement("input");
        writer.startElement("label", editor);
        writer.writeAttribute("for", "kupu-table-makeheader", null);
        writer.write("Create");
        writer.endElement("label");
        writer.endElement("div");
        writer.startElement("div", editor);
        writer.writeAttribute("class", "kupu-toolbox-buttons", null);
        InputHtmlRenderer.writeButton(writer, "kupu-table-fixall-button", "Fix Table", editor);
        InputHtmlRenderer.writeButton(writer, "kupu-table-addtable-button", "Add Table", editor);
        writer.endElement("div");
        writer.endElement("div");
        writer.startElement("div", editor);
        writer.writeAttribute("id", "kupu-toolbox-edittable", null);
        writer.writeAttribute("class", "kupu-toolbox-edittable", null);
        writer.startElement("div", editor);
        writer.writeAttribute("class", "kupu-toolbox-label", null);
        writer.write("Col Align:");
        writer.startElement("select", editor);
        writer.writeAttribute("class", "wide", null);
        writer.writeAttribute("id", "kupu-table-alignchooser", null);
        InputHtmlRenderer.writeOption(writer, "left", "Left", editor);
        InputHtmlRenderer.writeOption(writer, "center", "Center", editor);
        InputHtmlRenderer.writeOption(writer, "right", "Right", editor);
        writer.endElement("select");
        writer.endElement("div");
        writer.startElement("div", editor);
        writer.writeAttribute("class", "kupu-toolbox-buttons", null);
        writer.write("<br/>");
        InputHtmlRenderer.writeButton(writer, "kupu-table-addcolumn-button", "Add Column", editor);
        InputHtmlRenderer.writeButton(writer, "kupu-table-delcolumn-button", "Remove Column", editor);
        writer.write("<br/>");
        InputHtmlRenderer.writeButton(writer, "kupu-table-addrow-button", "Add Row", editor);
        InputHtmlRenderer.writeButton(writer, "kupu-table-delrow-button", "Remove Row", editor);
        InputHtmlRenderer.writeButton(writer, "kupu-table-fix-button", "Fix", editor);
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("div");
        writer.startElement("div", editor);
        writer.writeAttribute("class", "kupu-toolbox", null);
        writer.writeAttribute("id", "kupu-toolbox-cleanupexpressions", null);
        if (!editor.isShowCleanupExpressionsToolBox()) {
            writer.writeAttribute("style", "display: none", null);
        }
        writer.startElement("h1", editor);
        writer.writeAttribute("class", "kupu-toolbox-heading", null);
        writer.writeAttribute("i18n:translate", "", null);
        writer.write("Cleanup expressions");
        writer.endElement("h1");
        writer.startElement("div", editor);
        writer.startElement("div", editor);
        writer.writeAttribute("class", "kupu-toolbox-label", null);
        writer.startElement("span", editor);
        writer.writeAttribute("xmlns:i18n", "http://xml.zope.org/namespaces/i18n", null);
        writer.writeAttribute("i18n:translate", "", null);
        writer.write("Select a cleanup action:");
        writer.endElement("span");
        writer.endElement("div");
        writer.startElement("select", editor);
        writer.writeAttribute("id", "kupucleanupexpressionselect", null);
        writer.writeAttribute("class", "kupu-toolbox-st", null);
        writer.endElement("select");
        writer.startElement("div", editor);
        writer.writeAttribute("style", "text-align: center", null);
        writer.startElement("button", editor);
        writer.writeAttribute("type", "button", null);
        writer.writeAttribute("id", "kupucleanupexpressionbutton", null);
        writer.writeAttribute("class", "kupu-toolbox-action", null);
        writer.write("Perform action");
        writer.endElement("button");
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("div");
        writer.startElement("div", editor);
        writer.writeAttribute("class", "kupu-toolbox", null);
        writer.writeAttribute("id", "kupu-toolbox-debug", null);
        if (!editor.isShowDebugToolBox()) {
            writer.writeAttribute("style", "display: none", null);
        }
        writer.startElement("h1", editor);
        writer.writeAttribute("class", "kupu-toolbox-heading", null);
        writer.writeAttribute("i18n:translate", "debug-log", null);
        writer.write("Debug Log");
        writer.endElement("h1");
        writer.startElement("div", editor);
        writer.writeAttribute("id", "kupu-toolbox-debuglog", null);
        writer.writeAttribute("class", "kupu-toolbox-label", null);
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("div");
        writer.startElement("table", editor);
        writer.writeAttribute("id", "kupu-colorchooser", null);
        writer.writeAttribute("cellpadding", "0", null);
        writer.writeAttribute("cellspacing", "0", null);
        writer.writeAttribute("style", "position: fixed; border-style: solid; border-color: black; border-width: 1px;", null);
        writer.endElement("table");
        writer.startElement("div", editor);
        if (!editor.isShowAnyToolBox()) {
            writer.writeAttribute("style", "margin-right: 0.3em", null);
        }
        if (editor.getStyle() != null) {
            AddResource.addInlineStyleToHeader("#kupu-editor{height: inherit;}\ndiv.kupu-fulleditor{" + editor.getStyle() + "}", context);
        }
        writer.writeAttribute("class", "kupu-editorframe" + (editor.getStyleClass() == null ? "" : " " + editor.getStyleClass()), null);
        writer.startElement("iframe", editor);
        writer.writeAttribute("id", InputHtmlRenderer.getIFrameID(editor, context), null);
        writer.writeAttribute("class", "kupu-editor-iframe", null);
        writer.writeAttribute("frameborder", "0", null);
        writer.writeAttribute("scrolling", "auto", null);
        writer.writeAttribute("src", "about:blank", null);
        writer.writeAttribute("onmouseover", "myFacesKupuReactivateDesignMode(this)", null);
        writer.writeAttribute("onfocus", "myFacesKupuReactivateDesignMode(this)", null);
        writer.endElement("iframe");
        writer.startElement("textarea", editor);
        writer.writeAttribute("class", "kupu-editor-textarea", null);
        writer.writeAttribute("id", "kupu-editor-textarea", null);
        writer.write(32);
        writer.endElement("textarea");
        writer.endElement("div");
        writer.endElement("div");
        String text = editor.getValueAsHtmlDocument(context);
        String encodedText = text == null ? "" : JavascriptUtils.encodeString(text);
        String resourceBaseURL = AddResource.getResourceMappedPath(class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer == null ? (class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer = InputHtmlRenderer.class$("org.apache.myfaces.custom.inputHtml.InputHtmlRenderer")) : class$org$apache$myfaces$custom$inputHtml$InputHtmlRenderer, "", context);
        writer.startElement("script", editor);
        writer.writeAttribute("type", "text/javascript", null);
        writer.write("myFacesKupuSet(\"" + encodedText + "\"," + "\"" + clientId + "\"," + "\"" + formId + "\"," + "\"" + resourceBaseURL + "\"" + ");");
        writer.endElement("script");
    }

    private static String getIFrameID(InputHtml editor, FacesContext context) {
        return editor.getClientId(context) + "_iframe";
    }

    private static void writeTag(ResponseWriter writer, String tagName, String tagBody, UIComponent component) throws IOException {
        writer.startElement(tagName, component);
        writer.writeText(tagBody, null);
        writer.endElement(tagName);
    }

    private static void writeButton(ResponseWriter writer, String classAttr, String title, String accessKey, UIComponent component) throws IOException {
        InputHtmlRenderer.writeButton(writer, classAttr, title, accessKey, classAttr + "-button", component);
    }

    private static void writeButton(ResponseWriter writer, String classAttr, String title, String accessKey, String id, UIComponent component) throws IOException {
        InputHtmlRenderer.writeButton(writer, classAttr, title, accessKey, id, true, component);
    }

    private static void writeButton(ResponseWriter writer, String classAttr, String title, String accessKey, String id, boolean display, UIComponent component) throws IOException {
        writer.startElement("button", component);
        writer.writeAttribute("xmlns:i18n", "http://xml.zope.org/namespaces/i18n", null);
        writer.writeAttribute("type", "button", null);
        writer.writeAttribute("class", classAttr, null);
        writer.writeAttribute("id", id, null);
        writer.writeAttribute("title", title, null);
        writer.writeAttribute("i18n:attributes", "title", null);
        if (!display) {
            writer.writeAttribute("style", "display: none", null);
        }
        if (accessKey != null) {
            writer.writeAttribute("accesskey", accessKey, null);
        }
        writer.write(" ");
        writer.endElement("button");
    }

    private static void writeButton(ResponseWriter writer, String id, String text, UIComponent component) throws IOException {
        writer.startElement("button", component);
        writer.writeAttribute("type", "button", null);
        writer.writeAttribute("id", id, null);
        writer.write(text);
        writer.endElement("button");
    }

    private static void writeOption(ResponseWriter writer, String value, String body, UIComponent component) throws IOException {
        writer.startElement("option", component);
        writer.writeAttribute("value", value, null);
        writer.write(body);
        writer.endElement("option");
    }

    private static void writeOption(ResponseWriter writer, String value, String translate, String body, UIComponent component) throws IOException {
        writer.startElement("option", component);
        writer.writeAttribute("xmlns:i18n", "http://xml.zope.org/namespaces/i18n", null);
        writer.writeAttribute("value", value, null);
        writer.writeAttribute("i18n:translate", translate, null);
        writer.write(body);
        writer.endElement("option");
    }

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        RendererUtils.checkParamValidity(facesContext, uiComponent, class$org$apache$myfaces$custom$inputHtml$InputHtml == null ? (class$org$apache$myfaces$custom$inputHtml$InputHtml = InputHtmlRenderer.class$("org.apache.myfaces.custom.inputHtml.InputHtml")) : class$org$apache$myfaces$custom$inputHtml$InputHtml);
        InputHtml editor = (InputHtml)uiComponent;
        Map paramMap = facesContext.getExternalContext().getRequestParameterMap();
        String clientId = uiComponent.getClientId(facesContext);
        if (paramMap.containsKey(clientId)) {
            String submitedText = (String)paramMap.get(clientId);
            String htmlText = InputHtmlRenderer.useFallback(editor) ? HTMLEncoder.encode(submitedText, true, true) : submitedText;
            ((EditableValueHolder)((Object)uiComponent)).setSubmittedValue(htmlText);
        } else if (!HtmlRendererUtils.isDisabledOrReadOnly(editor)) {
            ((EditableValueHolder)((Object)uiComponent)).setSubmittedValue(RendererUtils.EMPTY_STRING);
        }
    }

    public Object getConvertedValue(FacesContext facesContext, UIComponent uiComponent, Object submittedValue) throws ConverterException {
        RendererUtils.checkParamValidity(facesContext, uiComponent, class$org$apache$myfaces$custom$inputHtml$InputHtml == null ? (class$org$apache$myfaces$custom$inputHtml$InputHtml = InputHtmlRenderer.class$("org.apache.myfaces.custom.inputHtml.InputHtml")) : class$org$apache$myfaces$custom$inputHtml$InputHtml);
        InputHtml editor = (InputHtml)uiComponent;
        String submittedDocument = (String)RendererUtils.getConvertedUIOutputValue(facesContext, editor, submittedValue);
        return editor.getValueFromDocument(submittedDocument);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

