/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.prefs.Preferences;

public class RecentItems {
    private List<String> recentNames = new ArrayList<String>();
    public static final int DEFAULT_MAX_RECENT_FILES = 5;
    private final int maxRecentFiles;
    private String RECENT_ITEMS_KEY = "recent_items";
    private final Preferences prefsNode;
    private Callback callback;

    public RecentItems(Preferences prefs, Callback cb, int max) {
        this.prefsNode = prefs;
        this.callback = cb;
        this.maxRecentFiles = max;
    }

    public RecentItems(Preferences prefs, Callback cb) {
        this(prefs, cb, 5);
    }

    public void putRecent(String f) {
        while (this.recentNames.size() > this.maxRecentFiles - 1) {
            this.recentNames.remove(this.recentNames.size() - 1);
        }
        if (this.recentNames.contains(f)) {
            this.recentNames.remove(f);
        }
        this.recentNames.add(0, f);
        for (int i = 0; i < this.recentNames.size(); ++i) {
            String t = this.recentNames.get(i);
            this.prefsNode.put(this.makeName(i), t);
        }
        this.callCallBack();
    }

    private void callCallBack() {
        if (this.callback != null) {
            this.callback.reload(this.getList());
        }
    }

    String makeName(int i) {
        return this.RECENT_ITEMS_KEY + "." + i;
    }

    public List<String> getList() {
        return Collections.unmodifiableList(this.recentNames);
    }

    public void clear() {
        for (int i = 0; i < this.maxRecentFiles; ++i) {
            this.prefsNode.remove(this.makeName(i));
        }
        this.callCallBack();
    }

    public void remove(String f) {
        this.recentNames.remove(f);
    }

    public static interface Callback {
        public void reload(List<String> var1);
    }
}

