/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class FixedLengthFIFO<T>
implements List<T> {
    private final int size;
    private long generation;
    private final T[] data;
    private int n = 0;
    private static final long serialVersionUID = 5887759670059817977L;

    public FixedLengthFIFO(int size) {
        this.size = size;
        this.data = new Object[size];
        this.n = 0;
    }

    @Override
    public int size() {
        return this.n;
    }

    @Override
    public boolean isEmpty() {
        return this.size <= 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int ix = -1;
            final long gen = FixedLengthFIFO.access$000(FixedLengthFIFO.this);

            @Override
            public boolean hasNext() {
                this.check();
                return this.ix < FixedLengthFIFO.this.n - 1;
            }

            @Override
            public T next() {
                this.check();
                if (!this.hasNext()) {
                    throw new IllegalStateException("Called next when hasNext is false");
                }
                return FixedLengthFIFO.this.data[++this.ix];
            }

            @Override
            public void remove() {
                this.check();
                if (this.ix == -1) {
                    throw new IllegalStateException("You called remove before next");
                }
                throw new UnsupportedOperationException("iterator.remove");
            }

            private void check() {
                if (this.gen != FixedLengthFIFO.this.generation) {
                    throw new ConcurrentModificationException();
                }
            }
        };
    }

    @Override
    public Object[] toArray() {
        return (Object[])this.data.clone();
    }

    @Override
    public <U> U[] toArray(U[] a) {
        if (a.length < this.size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.n);
        }
        System.arraycopy(this.data, 0, a, 0, this.n);
        return a;
    }

    @Override
    public boolean add(T o) {
        ++this.generation;
        if (this.n >= this.size) {
            this.remove(this.data[0]);
        }
        this.data[this.n++] = o;
        return true;
    }

    @Override
    public boolean remove(Object o) {
        int i = this.indexOf(o);
        if (i == -1) {
            return false;
        }
        return this.remove(i) != null;
    }

    @Override
    public T remove(int i) {
        ++this.generation;
        if (i > this.n) {
            return null;
        }
        --this.n;
        T old = this.data[i];
        if (this.size() == 0) {
            this.data[0] = null;
            return old;
        }
        if (i == 0) {
            System.arraycopy(this.data, 1, this.data, 0, this.n - 1);
            return old;
        }
        if (i == this.n - 1) {
            this.data[i] = null;
            return old;
        }
        System.arraycopy(this.data, i + 1, this.data, i, this.n - i - 1);
        return old;
    }

    @Override
    public boolean containsAll(Collection c) {
        throw new UnsupportedOperationException("containsAll");
    }

    @Override
    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException("addAll");
    }

    @Override
    public boolean addAll(int index, Collection c) {
        throw new UnsupportedOperationException("addAll");
    }

    @Override
    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException("removeAll");
    }

    @Override
    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException("retainAll");
    }

    @Override
    public void clear() {
        ++this.generation;
        for (int i = 0; i < this.n; ++i) {
            this.data[i] = null;
        }
    }

    @Override
    public T get(int index) {
        if (this.n > this.size) {
            throw new ArrayIndexOutOfBoundsException(Integer.toString(index));
        }
        return this.data[index];
    }

    @Override
    public T set(int index, T element) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        for (int ix = this.n; ix < index; ++ix) {
            this.data[ix] = null;
        }
        this.data[index] = element;
        return element;
    }

    @Override
    public void add(int index, T element) {
        throw new UnsupportedOperationException("add(int, element)");
    }

    @Override
    public int indexOf(Object o) {
        for (int i = 0; i < this.n; ++i) {
            if (!this.data[i].equals(o)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        for (int i = this.n - 1; i >= 0; --i) {
            if (!this.data[i].equals(o)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public ListIterator<T> listIterator() {
        throw new UnsupportedOperationException("listIterator");
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        throw new UnsupportedOperationException("listIterator(int)");
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this.size()) {
            throw new IndexOutOfBoundsException("must be in 0.." + (this.size() - 1));
        }
        int newlen = toIndex - fromIndex + 1;
        Object[] newdata = new Object[newlen];
        System.arraycopy(this.data, fromIndex, newdata, 0, newlen);
        return Arrays.asList(newdata);
    }

    @Override
    public int hashCode() {
        return this.data.hashCode();
    }
}

