/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.sql;

import com.darwinsys.database.DataBaseException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

public class SQLUtils {
    public static void resultSetToHTML(ResultSet rs, PrintWriter out, String titleStyle, String style1, String style2, String keyColName, String link) throws SQLException {
        ResultSetMetaData md = rs.getMetaData();
        int count = md.getColumnCount();
        out.println("<table border=1>");
        out.printf("<tr id='%s'>", titleStyle);
        for (int i = 1; i <= count; ++i) {
            out.printf("<th>%s</td>%n", md.getColumnName(i));
        }
        out.println("</tr>");
        int rowNum = 0;
        while (rs.next()) {
            out.printf("<tr class='%s'>", rowNum++ % 2 == 1 ? style1 : style2);
            for (int i = 1; i <= count; ++i) {
                String linkText = rs.getString(i);
                if (md.getColumnName(i).equals(keyColName)) {
                    linkText = String.format("<a href='%s%s'>%s</a>", link, linkText, linkText);
                }
                out.printf("<td>%s</td>", linkText);
            }
            out.println("</tr>");
        }
        out.println("</table>");
    }

    public static void resultSetToHTML(ResultSet rs, PrintWriter out) throws SQLException {
        SQLUtils.resultSetToHTML(rs, out, null, null, null, null, null);
    }

    public static void cleanup(ResultSet rs, Statement st, Connection conn) {
        try {
            if (rs != null) {
                rs.close();
            }
            if (st != null) {
                st.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e) {
            throw new DataBaseException("Cleanup caught exception: " + e);
        }
    }
}

