/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.sql;

import com.darwinsys.sql.ResultsDecorator;
import com.darwinsys.util.Verbosity;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class ResultsDecoratorSQL
extends ResultsDecorator {
    public ResultsDecoratorSQL(PrintWriter out, Verbosity v) {
        super(out, v);
    }

    @Override
    public int write(ResultSet rs) throws IOException, SQLException {
        ResultSetMetaData metadata = rs.getMetaData();
        String tableName = metadata.getTableName(1);
        if (tableName == null) {
            tableName = "XXXTABLENAMEXXX";
            System.err.println("Warning: at least one tablename null");
        }
        int colCount = metadata.getColumnCount();
        StringBuffer sb = new StringBuffer("insert into ").append(tableName).append("(");
        for (int i = 1; i <= colCount; ++i) {
            sb.append(metadata.getColumnName(i));
            if (i == colCount) continue;
            sb.append(", ");
        }
        sb.append(") values (");
        String insertCommand = sb.toString();
        int rowCount = 0;
        while (rs.next()) {
            ++rowCount;
            this.println(insertCommand);
            for (int i = 1; i <= colCount; ++i) {
                String tmp = rs.getString(i);
                if (rs.wasNull()) {
                    this.print("null");
                } else {
                    switch (metadata.getColumnType(i)) {
                        case -5: 
                        case 3: 
                        case 4: 
                        case 6: 
                        case 8: {
                            break;
                        }
                        case -1: 
                        case 1: 
                        case 12: 
                        case 2005: {
                            tmp = this.duplicateSingleQuotes(tmp);
                            tmp = this.wrapInDoubleQuotes(tmp);
                            break;
                        }
                        case 91: 
                        case 92: 
                        case 93: {
                            tmp = this.wrapInDoubleQuotes(tmp);
                            break;
                        }
                    }
                    this.print(tmp);
                }
                if (i == colCount) continue;
                this.print(", ");
            }
            this.println(");");
        }
        return rowCount;
    }

    @Override
    public void displayTable(String tableName, ResultSet rs) throws IOException, SQLException {
        this.println("create table " + tableName + " (");
        while (rs.next()) {
            String defaultValue;
            this.print("\t" + rs.getString(4) + ' ' + rs.getString(6));
            int nullable = rs.getInt(11);
            if (nullable == 0) {
                this.print(" not null");
            }
            if ((defaultValue = rs.getString(13)) != null) {
                this.print(" default('" + defaultValue + "')");
            }
            this.println(",");
        }
        this.println(");");
    }

    private String duplicateSingleQuotes(String input) {
        return input.replaceAll("'", "''");
    }

    private String wrapInDoubleQuotes(String input) {
        return String.format("'%s'", input);
    }

    @Override
    public void printRowCount(int rowCount) throws IOException {
        this.println("-- RowCount: " + rowCount);
    }

    @Override
    public String getName() {
        return "SQL";
    }
}

