/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.locks;

import com.darwinsys.locks.Lock;
import com.darwinsys.locks.LockImpl;
import com.darwinsys.locks.PessimisticLockManager;
import com.darwinsys.locks.PessimisticLockManagerImpl;
import java.util.Date;
import java.util.Map;

public class LockReaperImpl<T>
extends Thread {
    private static final int DEFAULT_TIMEOUT_MINUTES = 15;
    private int timeOutMinutes;
    private static final int RUN_INTERVAL = 60;
    private int sleepSeconds = 60;
    private final PessimisticLockManager<T> mgr;
    private boolean done;

    public LockReaperImpl(PessimisticLockManager<T> mgr) {
        this(mgr, 15);
    }

    public LockReaperImpl(PessimisticLockManager<T> mgr, int minutes) {
        this.timeOutMinutes = minutes;
        this.mgr = mgr;
    }

    @Override
    public void run() {
        while (!this.done) {
            this.timeOutMinutes = this.mgr.getTimeout();
            Map map = ((PessimisticLockManagerImpl)this.mgr).getLockStore();
            if (map.keySet().size() > 0) {
                System.out.println("LockReaper: Locks currently held at " + new Date() + ":");
            }
            for (Lock lock : map.keySet()) {
                long then;
                LockImpl l = (LockImpl)lock;
                System.out.println("LockReaper: " + l);
                long now = System.currentTimeMillis();
                if (now - (then = l.getCreationTime()) <= (long)(this.timeOutMinutes * 60000)) continue;
                System.out.println("LockReaper: Removing stale lock " + l);
                this.mgr.releaseLock(l);
            }
            try {
                Thread.sleep(1000 * this.sleepSeconds);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void setDone(boolean done) {
        this.done = done;
    }
}

