/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.io;

import com.darwinsys.util.Debug;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class FileIO {
    protected static final int BLKSIZ = 16384;
    public static final String ENCODING_UTF_8 = "UTF-8";

    private FileIO() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(String inName, String outName) throws FileNotFoundException, IOException {
        BufferedInputStream is = null;
        FilterOutputStream os = null;
        try {
            is = new BufferedInputStream(new FileInputStream(inName));
            os = new BufferedOutputStream(new FileOutputStream(outName));
            FileIO.copyFile(is, os, false);
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
        }
    }

    public static void copyFile(InputStream is, OutputStream os, boolean close) throws IOException {
        int i;
        byte[] b = new byte[16384];
        while ((i = is.read(b)) != -1) {
            os.write(b, 0, i);
        }
        is.close();
        if (close) {
            os.close();
        }
    }

    public static void copyFile(Reader is, Writer os, boolean close) throws IOException {
        int b;
        while ((b = is.read()) != -1) {
            os.write(b);
        }
        is.close();
        if (close) {
            os.close();
        }
    }

    public static void copyFile(String inName, PrintWriter pw, boolean close) throws FileNotFoundException, IOException {
        BufferedReader ir = new BufferedReader(new FileReader(inName));
        FileIO.copyFile(ir, (Writer)pw, close);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File file, File target) throws IOException {
        if (!(file.exists() && file.isFile() && file.canRead())) {
            throw new IOException(file + " is not a readable file");
        }
        File dest = target;
        if (target.isDirectory()) {
            dest = new File(dest, file.getName());
        }
        InputStream is = null;
        OutputStream os = null;
        try {
            is = new FileInputStream(file);
            os = new FileOutputStream(dest);
            int count = 0;
            byte[] b = new byte[16384];
            while ((count = is.read(b)) != -1) {
                os.write(b, 0, count);
            }
        }
        finally {
            is.close();
            os.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFileBuffered(String inName, String outName) throws FileNotFoundException, IOException {
        FileInputStream is = null;
        OutputStream os = null;
        try {
            is = new FileInputStream(inName);
            os = new FileOutputStream(outName);
            int count = 0;
            byte[] b = new byte[16384];
            while ((count = ((InputStream)is).read(b)) != -1) {
                os.write(b, 0, count);
            }
        }
        finally {
            if (is != null) {
                ((InputStream)is).close();
            }
            if (os != null) {
                os.close();
            }
        }
    }

    public static void copyRecursively(File fromDir, File toDir, boolean create) throws IOException {
        Debug.printf("fileio", "copyRecursively(%s, %s%n", fromDir, toDir);
        if (!fromDir.exists()) {
            throw new IOException(String.format("Source directory %s does not exist", fromDir));
        }
        if (create) {
            toDir.mkdirs();
        } else if (!toDir.exists()) {
            throw new IOException(String.format("Destination dir %s must exist", toDir));
        }
        for (File src : fromDir.listFiles()) {
            if (src.isDirectory()) {
                File destSubDir = new File(toDir, src.getName());
                FileIO.copyRecursively(src, destSubDir, true);
                continue;
            }
            if (src.isFile()) {
                FileIO.copyFile(src, toDir);
                continue;
            }
            System.err.println(String.format("Warning: %s is neither file nor directory", src));
        }
    }

    public static void copyRecursively(File fromDir, File toDir) throws IOException {
        FileIO.copyRecursively(fromDir, toDir, false);
    }

    public static void deleteRecursively(File startDir) throws IOException {
        String startDirPath = startDir.getCanonicalPath();
        for (File f : startDir.listFiles()) {
            if (!f.getCanonicalPath().startsWith(startDirPath)) {
                throw new IOException("Attempted to go out of " + startDir);
            }
            if (!f.isDirectory()) continue;
            FileIO.deleteRecursively(f);
        }
        for (File f : startDir.listFiles()) {
            f.delete();
            if (!f.exists()) continue;
            System.err.println(f + " did not get deleted!");
        }
        startDir.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyRecursively(JarFile base, JarEntry startingDir, File toDir) throws IOException {
        if (!startingDir.isDirectory()) {
            throw new IOException(String.format("Starting point %s is not a directory", startingDir));
        }
        if (!toDir.exists()) {
            throw new IOException(String.format("Destination dir %s must exist", toDir));
        }
        Enumeration<JarEntry> all = base.entries();
        while (all.hasMoreElements()) {
            JarEntry file = all.nextElement();
            if (file.isDirectory()) {
                FileIO.copyRecursively(base, file, new File(toDir, file.getName()));
                continue;
            }
            InputStream is = null;
            OutputStream os = null;
            try {
                is = base.getInputStream(file);
                os = new FileOutputStream(new File(toDir, file.getName()));
                FileIO.copyFile(is, os, false);
            }
            finally {
                if (os != null) {
                    os.close();
                }
                if (is == null) continue;
                is.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readLine(String inName) throws FileNotFoundException, IOException {
        try (BufferedReader is = null;){
            is = new BufferedReader(new FileReader(inName));
            String line = null;
            line = is.readLine();
            is.close();
            String string = line;
            return string;
        }
    }

    public static String readerToString(Reader is) throws IOException {
        int n;
        StringBuffer sb = new StringBuffer();
        char[] b = new char[16384];
        while ((n = is.read(b)) > 0) {
            sb.append(b, 0, n);
        }
        return sb.toString();
    }

    public static String inputStreamToString(InputStream is) throws IOException {
        return FileIO.readerToString(new InputStreamReader(is));
    }

    public static String readAsString(String filename) throws IOException {
        return FileIO.readerToString(new FileReader(filename));
    }

    public static void stringToFile(String text, String fileName) throws IOException {
        BufferedWriter os = new BufferedWriter(new FileWriter(fileName));
        os.write(text);
        os.flush();
        os.close();
    }

    public static BufferedReader openFile(String fileName) throws IOException {
        return new BufferedReader(new FileReader(fileName));
    }
}

