/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.io;

import com.darwinsys.database.DataBaseException;
import com.darwinsys.io.Checkpointer;
import com.darwinsys.io.CrawlerCallback;
import com.darwinsys.io.FileHandler;
import com.darwinsys.io.NextFD;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Set;
import java.util.TreeSet;

public class Crawler
implements Checkpointer {
    private static boolean debug = false;
    private boolean verbose = false;
    private static FileHandler visitor;
    private FilenameFilter chooser;
    private FilenameFilter dirChooser = null;
    public static final CrawlerCallback JUST_PRINT;
    private CrawlerCallback eHandler;
    private Set<String> seenSet = new TreeSet<String>();

    public Crawler(FilenameFilter chooser, FileHandler fileVisitor) {
        this(chooser, null, fileVisitor);
    }

    public Crawler(FilenameFilter chooser, FilenameFilter dirChooser, FileHandler fileVisitor) {
        if (chooser == null) {
            throw new NullPointerException("Chooser may not be null");
        }
        this.chooser = chooser;
        this.dirChooser = dirChooser;
        Crawler.setVisitor(fileVisitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void crawl(File startDir) throws IOException {
        File[] dir = startDir.listFiles();
        if (dir == null) {
            System.err.println("Warning: list of " + startDir + " returned null");
            return;
        }
        for (File next : dir) {
            int nextFreeFD;
            block16: {
                if (next.isDirectory()) {
                    if (this.dirChooser != null && !this.dirChooser.accept(next, null) || this.seen(next)) continue;
                    if (next.canRead()) {
                        this.checkpoint(next);
                        this.crawl(next);
                        continue;
                    }
                    System.err.println("The directory " + next.getAbsolutePath() + " is not readable, ignored.");
                    continue;
                }
                String nextFileName = next.getName();
                if (nextFileName == null) {
                    System.err.println("Warning: " + startDir + " contains null filename(s)");
                    continue;
                }
                nextFreeFD = -1;
                if (!next.isFile()) continue;
                if (!next.canRead()) {
                    System.err.println(nextFileName + " is not readable, ignored.");
                    continue;
                }
                try {
                    if (this.chooser != null) {
                        if (this.chooser.accept(startDir, nextFileName)) {
                            nextFreeFD = NextFD.getNextFD();
                            this.visitFile(next);
                        }
                        break block16;
                    }
                    this.visitFile(next);
                }
                catch (IOException e) {
                    block17: {
                        e.printStackTrace();
                        if (this.eHandler != null) {
                            this.eHandler.handleException(e);
                            break block17;
                        }
                        throw e;
                    }
                    if (nextFreeFD == -1 || NextFD.getNextFD() == nextFreeFD) continue;
                    System.err.printf("Hey, processing %s lost a file descriptor!", next);
                    continue;
                }
                catch (DataBaseException e2) {
                    System.err.println("There was a database problem trying to visit: " + next.getAbsolutePath());
                    System.err.println(e2.getCause());
                    {
                        catch (Throwable throwable) {
                            if (nextFreeFD != -1 && NextFD.getNextFD() != nextFreeFD) {
                                System.err.printf("Hey, processing %s lost a file descriptor!", next);
                            }
                            throw throwable;
                        }
                    }
                    if (nextFreeFD == -1 || NextFD.getNextFD() == nextFreeFD) continue;
                    System.err.printf("Hey, processing %s lost a file descriptor!", next);
                    continue;
                }
            }
            if (nextFreeFD == -1 || NextFD.getNextFD() == nextFreeFD) continue;
            System.err.printf("Hey, processing %s lost a file descriptor!", next);
        }
    }

    private void visitFile(File next) throws IOException {
        if (this.verbose) {
            System.out.printf("Starting file: %s%n", next.getAbsolutePath());
        }
        visitor.visit(next);
    }

    private boolean seen(File next) throws IOException {
        String path = next.getCanonicalPath();
        boolean seen = this.seenSet.contains(path);
        if (!seen) {
            this.seenSet.add(path);
        }
        return seen;
    }

    private void checkpoint(File next) {
    }

    public CrawlerCallback getEHandler() {
        return this.eHandler;
    }

    public void setEHandler(CrawlerCallback handler) {
        this.eHandler = handler;
        if (debug) {
            Thread.setDefaultUncaughtExceptionHandler(this.eHandler);
        }
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public static boolean isDebug() {
        return debug;
    }

    public static FileHandler getVisitor() {
        return visitor;
    }

    public static void setVisitor(FileHandler visitor) {
        Crawler.visitor = visitor;
    }

    static {
        JUST_PRINT = new CrawlerCallback(){

            @Override
            public void handleException(Throwable t) {
                System.err.printf("File %s caused exception (%s)\n", visitor.getFile().getAbsolutePath(), t);
                if (Crawler.isDebug()) {
                    t.printStackTrace();
                } else {
                    Throwable t2 = t.getCause();
                    if (t2 != null) {
                        System.err.println("Cause: " + t2);
                    }
                }
            }
        };
    }
}

