/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.util;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;

public class ScaledNumberFormat
extends Format {
    private static final long serialVersionUID = 1030043222640098114L;
    static final int NONE = 0;
    static final int KILO = 1;
    static final int MEGA = 2;
    static final int GIGA = 3;
    static final int TERA = 4;
    static final int PETA = 5;
    static final int EXA = 6;
    DecimalFormat df;
    static char[] scale_chars = new char[]{'B', 'K', 'M', 'G', 'T', 'P', 'E'};
    int[] units = new int[]{0, 1, 2, 3, 4, 5, 6};
    static long[] scale_factors = new long[]{1L, 1024L, 0x100000L, 0x40000000L, 0x10000000000L, 0x4000000000000L, 0x1000000000000000L};
    private static final long LLONG_MAX = scale_factors[6];
    static final int MAX_DIGITS = 10;

    public ScaledNumberFormat() {
        this.df = new DecimalFormat("0");
    }

    @Override
    public Object parseObject(String s, ParsePosition where) {
        int i;
        int sign = 0;
        int fract_digits = 0;
        long scale_fact = 1L;
        long whole = 0L;
        long fpart = 0L;
        if (s == null) {
            return null;
        }
        char[] b = s.trim().toCharArray();
        int p = 0;
        while (b[p] == '-' || b[p] == '+') {
            if (b[p] == '-') {
                if (sign != 0) {
                    throw new NumberFormatException("Number " + s + " has more than one sign.");
                }
                sign = -1;
                ++p;
                continue;
            }
            if (b[p] != '+') continue;
            if (sign != 0) {
                throw new NumberFormatException("Number " + s + " has more than one sign.");
            }
            sign = 1;
            ++p;
        }
        while (p < b.length && (Character.isDigit(b[p]) || b[p] == '.')) {
            int ndigits = 0;
            if (b[p] == '.') {
                if (fract_digits > 0) {
                    throw new NumberFormatException("Number " + s + " has more than one decimal point ");
                }
                fract_digits = 1;
            } else {
                i = b[p] - 48;
                if (fract_digits > 0) {
                    if (fract_digits >= 10) {
                        throw new NumberFormatException("Number too large");
                    }
                    fpart *= 10L;
                    fpart += (long)i;
                    ++fract_digits;
                } else {
                    if (++ndigits >= 10) {
                        throw new NumberFormatException("Number too large");
                    }
                    whole *= 10L;
                    whole += (long)i;
                }
            }
            ++p;
        }
        if (sign < 0) {
            whole *= (long)sign;
            fpart *= (long)sign;
        }
        if (p >= b.length) {
            return new Long(whole);
        }
        for (i = 0; i < scale_factors.length; ++i) {
            if (b[p] != scale_chars[i] && b[p] != Character.toLowerCase(scale_chars[i])) continue;
            scale_fact = scale_factors[i];
            whole *= scale_fact;
            while (fpart >= LLONG_MAX / scale_fact) {
                fpart /= 10L;
                --fract_digits;
            }
            fpart *= scale_fact;
            if (fract_digits > 0) {
                for (i = 0; i < fract_digits - 1; ++i) {
                    fpart /= 10L;
                }
            }
            return new Long(whole += fpart);
        }
        throw new IllegalArgumentException("invalid scale factor " + b[p]);
    }

    @Override
    public Object parseObject(String arg0) throws ParseException {
        return this.parseObject(arg0, null);
    }

    @Override
    public StringBuffer format(Object on, StringBuffer sb, FieldPosition fp) {
        if (on instanceof String) {
            String son = (String)on;
            if (son.length() == 0) {
                return sb.append("0B");
            }
            on = this.parseObject(son, null);
        }
        if (!(on instanceof Long)) {
            throw new IllegalArgumentException("Argument " + on + " must be String or Long");
        }
        long n = (Long)on;
        sb.append(this.format(n));
        return sb;
    }

    public String format(double n) {
        return this.format((long)n);
    }

    public String format(long number) {
        long fract = 0L;
        int unit = 0;
        StringBuffer buf = new StringBuffer();
        long abval = Math.abs(number);
        for (int i = 1; i < scale_factors.length; ++i) {
            if (abval >= scale_factors[i]) continue;
            unit = this.units[i - 1];
            fract = i == 1 ? 0L : abval % scale_factors[i - 1];
            number /= scale_factors[i - 1];
            break;
        }
        if (fract < 0L) {
            fract = -fract;
        }
        while (fract > 9L) {
            fract /= 10L;
        }
        if (number == 0L) {
            return "0B";
        }
        if (unit == 0 || number >= 100L || number <= -100L) {
            buf.append(this.df.format(number)).append(scale_chars[unit]);
        } else {
            buf.append(this.df.format(number)).append('.').append(fract).append(scale_chars[unit]);
        }
        return buf.toString();
    }
}

