/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PropertiesMap
implements Map<String, String> {
    private List<String> names = new ArrayList<String>();
    private List<String> values = new ArrayList<String>();

    public void load(String fileName) throws IOException {
        String line;
        if (fileName == null) {
            throw new IOException("filename is null!");
        }
        FileInputStream is = new FileInputStream(fileName);
        BufferedReader rdr = new BufferedReader(new InputStreamReader(is));
        while ((line = rdr.readLine()) != null) {
            int ix = line.indexOf(61);
            String name = line.substring(0, ix);
            String value = line.substring(ix + 1);
            this.names.add(name);
            this.values.add(value);
        }
        rdr.close();
    }

    @Override
    public int size() {
        return this.names.size();
    }

    @Override
    public boolean isEmpty() {
        return this.names.isEmpty();
    }

    @Override
    public boolean containsKey(Object obj) {
        return this.names.contains(obj);
    }

    @Override
    public boolean containsValue(Object obj) {
        return this.values.contains(obj);
    }

    @Override
    public String get(Object obj) {
        int where = this.names.indexOf(obj);
        if (where == -1) {
            return null;
        }
        return this.values.get(where);
    }

    @Override
    public String put(String n, String v) {
        this.names.add(n);
        this.values.add(v);
        return n;
    }

    @Override
    public String remove(Object obj) {
        String o = obj.toString();
        int i = this.values.indexOf(o);
        if (i < 0) {
            throw new IllegalArgumentException("remove(" + obj + ") not found");
        }
        this.names.remove(i);
        this.values.remove(i);
        return o;
    }

    @Override
    public void putAll(Map map) {
        for (Map.Entry e : map.entrySet()) {
            String key = (String)e.getKey();
            String val = (String)e.getValue();
            this.put(key, val);
        }
    }

    @Override
    public void clear() {
        this.names.clear();
        this.values.clear();
    }

    @Override
    public Set<String> keySet() {
        return new HashSet<String>(this.names);
    }

    @Override
    public Collection<String> values() {
        return this.values;
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return null;
    }
}

