/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.testing;

import com.darwinsys.testing.RandomDataGenerator;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.junit.Assert;

public class CheckAccessors {
    private static final boolean debug = true;

    public static void debug(String s) {
        System.out.println(s);
    }

    public static void process(String className) throws Exception {
        Class<?> c = Class.forName(className);
        CheckAccessors.process(c);
    }

    private static boolean isPublic(Member m) {
        return Modifier.isPublic(m.getModifiers());
    }

    public static void process(Class<?> c) throws Exception {
        PropertyDescriptor[] props;
        Object instance;
        if (c.isInterface() || c.isEnum() || c.isAnnotation()) {
            CheckAccessors.debug(c + " not an instantiable class");
            return;
        }
        if (Modifier.isAbstract(c.getModifiers())) {
            CheckAccessors.debug(c + " is abstract");
            return;
        }
        try {
            instance = c.newInstance();
        }
        catch (Exception e) {
            CheckAccessors.debug(c + ": newInstance fail: " + e);
            return;
        }
        Class<?> stopClass = c.getSuperclass();
        BeanInfo beanInfo = Introspector.getBeanInfo(c, stopClass);
        for (PropertyDescriptor p : props = beanInfo.getPropertyDescriptors()) {
            Class<?> type;
            Object value;
            String propName = p.getName();
            Method writeMethod = p.getWriteMethod();
            if (writeMethod == null || !CheckAccessors.isPublic(writeMethod) || (value = RandomDataGenerator.getRandomValue(type = p.getPropertyType())) == null) continue;
            writeMethod.invoke(instance, value);
            Method readMethod = p.getReadMethod();
            if (readMethod == null || !CheckAccessors.isPublic(readMethod)) continue;
            Object back = readMethod.invoke(instance, new Object[0]);
            Assert.assertEquals((String)(c.getName() + "." + propName), (Object)value, (Object)back);
        }
    }
}

