/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.swingui;

import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FontChooser
extends JDialog {
    private static final long serialVersionUID = 5363471384675038069L;
    public static final String DEFAULT_TEXT = "Lorem ipsem dolor";
    protected Font resultFont = new Font("Serif", 0, 12);
    protected String resultName;
    protected int resultSize;
    protected boolean isBold;
    protected boolean isItalic;
    protected String displayText = "Lorem ipsem dolor";
    protected JList fontNameChoice;
    protected JList fontSizeChoice;
    JCheckBox bold;
    JCheckBox italic;
    protected Integer[] fontSizes = new Integer[]{8, 9, 10, 11, 12, 14, 16, 18, 20, 24, 30, 36, 40, 48, 60, 72};
    protected static final int DEFAULT_SIZE = 4;
    protected JLabel previewArea;

    public FontChooser(JFrame f) {
        super(f, "Font Chooser", true);
        Container cp = this.getContentPane();
        JPanel top = new JPanel();
        top.setBorder(new TitledBorder(new EtchedBorder(), "Font"));
        top.setLayout(new FlowLayout());
        String[] fontList = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        this.fontNameChoice = new JList<String>(fontList);
        top.add(new JScrollPane(this.fontNameChoice));
        this.fontNameChoice.setVisibleRowCount(this.fontSizes.length);
        this.fontNameChoice.setSelectedValue("Serif", true);
        this.fontSizeChoice = new JList<Integer>(this.fontSizes);
        top.add(this.fontSizeChoice);
        this.fontSizeChoice.setSelectedIndex(this.fontSizes.length * 3 / 4);
        cp.add((Component)top, "North");
        JPanel attrs = new JPanel();
        top.add(attrs);
        attrs.setLayout(new GridLayout(0, 1));
        this.bold = new JCheckBox("Bold", false);
        attrs.add(this.bold);
        this.italic = new JCheckBox("Italic", false);
        attrs.add(this.italic);
        ListSelectionListener waker = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                FontChooser.this.previewFont();
            }
        };
        this.fontSizeChoice.addListSelectionListener(waker);
        this.fontNameChoice.addListSelectionListener(waker);
        ItemListener waker2 = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                FontChooser.this.previewFont();
            }
        };
        this.bold.addItemListener(waker2);
        this.italic.addItemListener(waker2);
        this.previewArea = new JLabel(this.displayText, 0);
        this.previewArea.setSize(200, 50);
        cp.add((Component)this.previewArea, "Center");
        JPanel bot = new JPanel();
        JButton okButton = new JButton("Apply");
        bot.add(okButton);
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FontChooser.this.previewFont();
                FontChooser.this.dispose();
                FontChooser.this.setVisible(false);
            }
        });
        JButton canButton = new JButton("Cancel");
        bot.add(canButton);
        canButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FontChooser.this.resultFont = null;
                FontChooser.this.resultName = null;
                FontChooser.this.resultSize = 0;
                FontChooser.this.isBold = false;
                FontChooser.this.isItalic = false;
                FontChooser.this.dispose();
                FontChooser.this.setVisible(false);
            }
        });
        cp.add((Component)bot, "South");
        this.previewFont();
        this.pack();
        this.setLocation(100, 100);
    }

    protected void previewFont() {
        this.resultName = (String)this.fontNameChoice.getSelectedValue();
        String resultSizeName = this.fontSizeChoice.getSelectedValue().toString();
        int resultSize = Integer.parseInt(resultSizeName);
        this.isBold = this.bold.isSelected();
        this.isItalic = this.italic.isSelected();
        int attrs = 0;
        if (this.isBold) {
            attrs = 1;
        }
        if (this.isItalic) {
            attrs |= 2;
        }
        this.resultFont = new Font(this.resultName, attrs, resultSize);
        this.previewArea.setFont(this.resultFont);
        this.pack();
    }

    public String getSelectedName() {
        return this.resultName;
    }

    public int getSelectedSize() {
        return this.resultSize;
    }

    public Font getSelectedFont() {
        return this.resultFont;
    }

    public String getDisplayText() {
        return this.displayText;
    }

    public void setDisplayText(String displayText) {
        this.displayText = displayText;
        this.previewArea.setText(displayText);
        this.previewFont();
    }

    public JList getFontNameChoice() {
        return this.fontNameChoice;
    }

    public JList getFontSizeChoice() {
        return this.fontSizeChoice;
    }

    public boolean isBold() {
        return this.isBold;
    }

    public boolean isItalic() {
        return this.isItalic;
    }
}

