/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.swingui;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.sql.SQLException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;

public class ErrorUtil {
    static final String[] choicesNoMore = new String[]{"OK", "Details..."};
    static final String[] choicesMore = new String[]{"OK", "Details...", "Next"};
    static DetailsDialog detailsDialog;

    public void handle(Throwable th) {
        ErrorUtil.showExceptions(null, th);
    }

    public static void showExceptions(Component parent, Throwable theExc) {
        Throwable next = null;
        do {
            String className;
            String message = className = theExc.getClass().getName();
            if (theExc instanceof SQLException) {
                SQLException sexc = (SQLException)theExc;
                message = message + "; code=" + sexc.getErrorCode();
                next = sexc.getNextException();
            } else {
                next = theExc.getCause();
            }
            Object[] choices = next != null ? choicesMore : choicesNoMore;
            int response = JOptionPane.showOptionDialog(parent, message, className, 1, 0, null, choices, choices[0]);
            if (response == 0) {
                return;
            }
            if (response == 1) {
                if (detailsDialog == null) {
                    detailsDialog = new DetailsDialog((JFrame)parent);
                }
                detailsDialog.showStackTrace(theExc);
            }
            theExc = next;
        } while (next != null);
    }

    protected static class DetailsDialog
    extends JDialog {
        private static final long serialVersionUID = -4779441441693785664L;
        JButton ok;
        JTextArea text;

        DetailsDialog(JFrame parent) {
            super(parent);
            Container cp = this.getContentPane();
            this.text = new JTextArea(40, 40);
            cp.add((Component)this.text, "Center");
            this.ok = new JButton("Close");
            cp.add((Component)this.ok, "South");
            this.ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    DetailsDialog.this.dispose();
                }
            });
            this.pack();
        }

        void showStackTrace(Throwable exc) {
            CharArrayWriter buff = new CharArrayWriter();
            PrintWriter pw = new PrintWriter(buff);
            exc.printStackTrace(pw);
            pw.close();
            this.text.setText(buff.toString());
            this.setVisible(true);
        }
    }
}

