/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.lang;

import com.darwinsys.lang.GetOptDesc;
import com.darwinsys.util.Debug;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GetOpt {
    protected List<String> fileNameArguments;
    protected final GetOptDesc[] options;
    protected int optind = 0;
    public static final int DONE = 0;
    protected boolean done = false;
    protected String optarg;

    public String optarg() {
        return this.optarg;
    }

    public String optArg() {
        return this.optarg;
    }

    public GetOpt(GetOptDesc[] opt) {
        this.options = (GetOptDesc[])opt.clone();
    }

    public GetOpt(String patt) {
        int i;
        if (patt == null) {
            throw new IllegalArgumentException("Pattern may not be null");
        }
        if (patt.charAt(0) == ':') {
            throw new IllegalArgumentException("Pattern incorrect, may not begin with ':'");
        }
        int n = 0;
        for (i = 0; i < patt.length(); ++i) {
            if (patt.charAt(i) == ':') continue;
            ++n;
        }
        if (n == 0) {
            throw new IllegalArgumentException("No option letters found in " + patt);
        }
        this.options = new GetOptDesc[n];
        int ix = 0;
        for (i = 0; i < patt.length(); ++i) {
            char c = patt.charAt(i);
            boolean argTakesValue = false;
            if (i < patt.length() - 1 && patt.charAt(i + 1) == ':') {
                argTakesValue = true;
                ++i;
            }
            Debug.println("getopt", "CONSTR: options[" + ix + "] = " + c + ", " + argTakesValue);
            this.options[ix++] = new GetOptDesc(c, null, argTakesValue);
        }
    }

    public void rewind() {
        this.fileNameArguments = null;
        this.done = false;
        this.optind = 0;
        this.optarg = null;
    }

    public Map<String, String> parseArguments(String[] argv) {
        HashMap<String, String> optionsValueMap = new HashMap<String, String>();
        this.fileNameArguments = new ArrayList<String>();
        for (int i = 0; i < argv.length; ++i) {
            Debug.println("getopt", "parseArg: i=" + i + ": arg " + argv[i]);
            char c = this.getopt(argv);
            if (c == '\u0000') {
                this.fileNameArguments.add(argv[i]);
                continue;
            }
            optionsValueMap.put(Character.toString(c), this.optarg);
            if (this.optarg == null) continue;
            ++i;
        }
        return optionsValueMap;
    }

    public List<String> getFilenameList() {
        if (this.fileNameArguments == null) {
            throw new IllegalArgumentException("Illegal call to getFilenameList() before parseOptions()");
        }
        return this.fileNameArguments;
    }

    public char getopt(String[] argv) {
        Debug.println("getopt", "optind=" + this.optind + ", argv.length=" + argv.length);
        if (this.optind >= argv.length || !argv[this.optind].startsWith("-")) {
            this.done = true;
        }
        if (this.done) {
            return '\u0000';
        }
        this.optarg = null;
        String thisArg = argv[this.optind];
        if (thisArg.startsWith("-")) {
            for (GetOptDesc option : this.options) {
                if ((thisArg.length() != 2 || option.getArgLetter() != thisArg.charAt(1)) && (option.getArgName() == null || !option.getArgName().equals(thisArg.substring(1)))) continue;
                if (option.takesArgument()) {
                    if (this.optind < argv.length - 1) {
                        this.optarg = argv[++this.optind];
                    } else {
                        throw new IllegalArgumentException("Option " + option.getArgLetter() + " needs value but found end of arg list");
                    }
                }
                ++this.optind;
                return option.getArgLetter();
            }
            ++this.optind;
            return '?';
        }
        ++this.optind;
        this.done = true;
        return '\u0000';
    }

    public int getOptInd() {
        return this.optind;
    }
}

