/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public class FileSaver {
    private State state;
    private final File inputFile;
    private final File tmpFile;
    private final File backupFile;

    public FileSaver(File input) throws IOException {
        this.inputFile = input;
        this.tmpFile = new File(this.inputFile.getAbsolutePath() + ".tmp");
        this.tmpFile.createNewFile();
        this.tmpFile.deleteOnExit();
        this.backupFile = new File(this.inputFile.getAbsolutePath() + ".bak");
        this.state = State.AVAILABLE;
    }

    public File getFile() {
        return this.inputFile;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.state != State.AVAILABLE) {
            throw new IllegalStateException("FileSaver not opened");
        }
        FileOutputStream out = new FileOutputStream(this.tmpFile);
        this.state = State.INUSE;
        return out;
    }

    public Writer getWriter() throws IOException {
        if (this.state != State.AVAILABLE) {
            throw new IllegalStateException("FileSaver not opened");
        }
        FileWriter out = new FileWriter(this.tmpFile);
        this.state = State.INUSE;
        return out;
    }

    public void finish() throws IOException {
        if (this.state != State.INUSE) {
            throw new IllegalStateException("FileSaver not in use");
        }
        this.backupFile.delete();
        if (this.inputFile.exists() && !this.inputFile.renameTo(this.backupFile)) {
            throw new IOException("Could not rename file to backup file");
        }
        if (!this.tmpFile.renameTo(this.inputFile)) {
            throw new IOException("Could not rename temp file to save file");
        }
        this.state = State.AVAILABLE;
    }

    private static enum State {
        AVAILABLE,
        INUSE;

    }
}

