/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.util.xml;

import org.apache.commons.logging.Log;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public class MyFacesErrorHandler
implements ErrorHandler {
    private Log _log;

    public MyFacesErrorHandler(Log log) {
        this._log = log;
    }

    public void warning(SAXParseException exception) {
        if (this._log.isWarnEnabled()) {
            this._log.warn((Object)this.getMessage(exception), (Throwable)exception);
        }
    }

    public void error(SAXParseException exception) {
        this._log.error((Object)this.getMessage(exception), (Throwable)exception);
    }

    public void fatalError(SAXParseException exception) {
        this._log.fatal((Object)this.getMessage(exception), (Throwable)exception);
    }

    private String getMessage(SAXParseException exception) {
        StringBuffer buf = new StringBuffer();
        buf.append("SAXParseException at");
        buf.append(" URI=");
        buf.append(exception.getSystemId());
        buf.append(" Line=");
        buf.append(exception.getLineNumber());
        buf.append(" Column=");
        buf.append(exception.getColumnNumber());
        return buf.toString();
    }
}

